% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbi.R
\name{connector_dbi}
\alias{connector_dbi}
\title{Create \code{dbi} connector}
\usage{
connector_dbi(drv, ..., extra_class = NULL)
}
\arguments{
\item{drv}{Driver object inheriting from \link[DBI:DBIDriver-class]{DBI::DBIDriver}.}

\item{...}{Additional arguments passed to \code{\link[DBI:dbConnect]{DBI::dbConnect()}}.}

\item{extra_class}{\link{character} Extra class to assign to the new connector.}
}
\value{
A new \link{ConnectorDBI} object
}
\description{
Initializes the connector for DBI type of storage.
See \link{ConnectorDBI} for details.
}
\details{
The \code{extra_class} parameter allows you to create a subclass of the
\code{ConnectorDBI} object. This can be useful if you want to create
a custom connection object for easier dispatch of new s3 methods, while still
inheriting the methods from the \code{ConnectorDBI} object.
}
\examples{

# Create DBI connector
cnt <- connector_dbi(RSQLite::SQLite(), ":memory:")
cnt

# Create subclass connection
cnt_subclass <- connector_dbi(RSQLite::SQLite(), ":memory:",
  extra_class = "subclass"
)
cnt_subclass
class(cnt_subclass)

}
