% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploy.R
\name{set_vanity_url}
\alias{set_vanity_url}
\title{Set the Vanity URL}
\usage{
set_vanity_url(content, url, force = FALSE)
}
\arguments{
\item{content}{A Content object}

\item{url}{The path component of the URL}

\item{force}{optional. Default FALSE. Whether to force-reassign a vanity URL that already exists}
}
\value{
An updated Content object
}
\description{
Set the vanity URL for a piece of content.
}
\examples{
\dontrun{
bnd <- bundle_dir("~/my/directory")
connect() \%>\%
  deploy(bnd) \%>\%
  set_vanity_url("a/vanity/url")
}

}
\seealso{
Other content functions: 
\code{\link{content_delete}()},
\code{\link{content_item}()},
\code{\link{content_title}()},
\code{\link{content_update}()},
\code{\link{create_random_name}()},
\code{\link{dashboard_url}()},
\code{\link{delete_thumbnail}()},
\code{\link{delete_vanity_url}()},
\code{\link{deploy_repo}()},
\code{\link{get_associations}()},
\code{\link{get_bundles}()},
\code{\link{get_environment}()},
\code{\link{get_image}()},
\code{\link{get_job}()},
\code{\link{get_jobs}()},
\code{\link{get_log}()},
\code{\link{get_thumbnail}()},
\code{\link{get_vanity_url}()},
\code{\link{git}},
\code{\link{has_thumbnail}()},
\code{\link{lock_content}()},
\code{\link{permissions}},
\code{\link{search_content}()},
\code{\link{set_image_path}()},
\code{\link{set_integrations}()},
\code{\link{set_run_as}()},
\code{\link{set_thumbnail}()},
\code{\link{swap_vanity_url}()},
\code{\link{swap_vanity_urls}()},
\code{\link{terminate_jobs}()},
\code{\link{verify_content_name}()}
}
\concept{content functions}
