% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tags.R
\name{get_tags}
\alias{get_tags}
\alias{get_tag_data}
\alias{create_tag}
\alias{create_tag_tree}
\alias{delete_tag}
\alias{get_content_tags}
\alias{set_content_tag_tree}
\alias{set_content_tags}
\alias{filter_tag_tree_id}
\alias{filter_tag_tree_chr}
\title{Get all Tags on the server}
\usage{
get_tags(src)

get_tag_data(src)

create_tag(src, name, parent = NULL)

create_tag_tree(src, ...)

delete_tag(src, tag)

get_content_tags(content)

set_content_tag_tree(content, ...)

set_content_tags(content, ...)

filter_tag_tree_id(tags, ids)

filter_tag_tree_chr(tags, pattern)
}
\arguments{
\item{src}{The source object}

\item{name}{The name of the tag to create}

\item{parent}{optional. A \code{connect_tag_tree} object (as returned by \code{get_tags()}) pointed at the parent tag}

\item{...}{Additional arguments

Manage tags (requires Administrator role):
\itemize{
\item \code{get_tags()} - returns a "tag tree" object that can be traversed with \code{tag_tree$tag1$childtag}
\item \code{get_tag_data()} - returns a tibble of tag data
\item \code{create_tag()} - create a tag by specifying the Parent directly
\item \code{create_tag_tree()} - create tag(s) by specifying the "desired" tag tree
hierarchy
\item \code{delete_tag()} - delete a tag (and its children). WARNING: will
disassociate any content automatically
}

Manage content tags:
\itemize{
\item \code{get_content_tags()} - return a \code{connect_tag_tree} object corresponding to
the tags for a piece of content.
\item \code{set_content_tag_tree()} - attach a tag to content by specifying the
desired tag tree
\item \code{set_content_tags()} - Set multiple tags at once by providing
\code{connect_tag_tree} objects
}

Search a tag tree:
\itemize{
\item \code{filter_tag_tree_chr()} - filters a tag tree based on a regex
\item \code{filter_tag_tree_id()} - filters a tag tree based on an id
\item 
}}

\item{tag}{A \code{connect_tag_tree} object (as returned by \code{get_tags()})}

\item{content}{An R6 Content object, as returned by \code{content_item()}}

\item{tags}{A \code{connect_tag_tree} object (as returned by \code{get_tags()})}

\item{ids}{A list of \code{id}s to filter the tag tree by}

\item{pattern}{A regex to filter the tag tree by (it is passed to \code{grepl})}
}
\description{
Tag manipulation and assignment functions
}
