% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vote_to_rollcall.R
\name{vote_to_rollcall}
\alias{vote_to_rollcall}
\title{Create rollcall or matrix format data structures from voting records}
\usage{
vote_to_rollcall(votes = NULL, legislators = NULL, bills = NULL,
  ideal = TRUE)
}
\arguments{
\item{votes}{\code{integer}. The recorded nominal votes. Must be in the format
1, 0, where 1 indicates a 'Yes' vote, 0 a 'No' vote. Missing values must be
\code{NA}.
All of the \code{votes}, \code{legislators} and \code{bills} parameters must
be vectors.}

\item{legislators}{This may be a vector of legislator names or id numbers.}

\item{bills}{A vector of bill numbers or ids.}

\item{ideal}{If TRUE, the default, returns a \code{rollcall} object for use with
pscl and/or wnominate. If FALSE, returns a matrix suitable for use with MCMCpack or
the JAGS modelling language.}
}
\description{
Returns votes from the Senate or Chamber of Deputies in a format
that can be easily used with other R packages (wnominate, pscl, MCMCpack) or
with other modelling languages such as JAGS.
}
\examples{
# get votes:
data(sen_nominal_votes)
votes <- sen_nominal_votes \%>\%
    dplyr::filter(vote_date >= "2005-03-01", vote_date <= "2007-12-15")
rc <- vote_to_rollcall(votes$senator_vote,
                       legislators = votes$senator_name,
                       bills = votes$bill_id)
}
\author{
Robert Myles McDonnell, Guilherme Jardim Duarte & Danilo Freire.
}
