% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_location_shift.R
\name{ci_quantile_diff}
\alias{ci_quantile_diff}
\title{CI for the Population Quantile Difference of two Samples}
\usage{
ci_quantile_diff(
  x,
  y,
  q = 0.5,
  probs = c(0.025, 0.975),
  type = "bootstrap",
  boot_type = c("bca", "perc", "norm", "basic"),
  R = 9999L,
  seed = NULL,
  ...
)
}
\arguments{
\item{x}{A numeric vector.}

\item{y}{A numeric vector.}

\item{q}{A single probability value determining the quantile (0.5 for median).}

\item{probs}{Lower and upper probabilities, by default \code{c(0.025, 0.975)}.}

\item{type}{Type of CI. Currently, "bootstrap" is the only option.}

\item{boot_type}{Type of bootstrap CI. Only used for \code{type = "bootstrap"}.}

\item{R}{The number of bootstrap resamples. Only used for \code{type = "bootstrap"}.}

\item{seed}{An integer random seed. Only used for \code{type = "bootstrap"}.}

\item{...}{Further arguments passed to \code{\link[boot:boot]{boot::boot()}}.}
}
\value{
An object of class "cint", see \code{\link[=ci_mean]{ci_mean()}} for details.
}
\description{
This function calculates bootstrap CIs for the population value of
q-quantile(x) - q-quantile(y), by default using "bca" bootstrap.
Resampling is done within sample.
}
\examples{
x <- 10:30
y <- 1:30
ci_quantile_diff(x, y, R = 999)  # Use larger R
}
\seealso{
\code{\link[=ci_median_diff]{ci_median_diff()}}
}
