% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read.config}
\alias{read.config}
\title{Read from the file (JSON/INI/YAML/TOML be supported), retreiving all values as a list.}
\usage{
read.config(file = Sys.getenv("R_CONFIGFILE_ACTIVE", "config.cfg"),
  extra.list = list(), other.config = "", rcmd.parse = FALSE,
  bash.parse = FALSE, glue.parse = FALSE, glue.flag = "!!glue",
  file.type = NULL, ...)
}
\arguments{
\item{file}{File name of configuration file to read from. Defaults to the value of
the 'R_CONFIGFILE_ACTIVE' environment variable ('config.cfg' if the
variable does not exist and JSON/INI/YAML/TOML format only)}

\item{extra.list}{A list that can replace the configuration file '{{debug}}' by list(debug = 'TRUE'), 
and {{debug}} will be setted to 'TRUE'}

\item{other.config}{Path of another configuration file that can replace the configuration file '{{key:value}}'}

\item{rcmd.parse}{Logical wheather parse '@>@str_replace('abc', 'b', 'c')@<@' that existed in config to 'acc'}

\item{bash.parse}{Logical wheather parse '#>#echo $HOME#<#' in config to your HOME PATH}

\item{glue.parse}{Logical wheather parse '!!glue{1:5}' in config to ['1','2','3','4','5']; 
['nochange', '!!glue(1:5)', 'nochange'] => ['nochange', '1', '2', '3', '4', '5', 'nochange']}

\item{glue.flag}{A character flage indicating wheater run glue() function to parse (Default is !!glue)}

\item{file.type}{Default is no need to specify the variable, file.type will be automatically 
identify by \code{\link{get.config.type}}. If the value be specified, the step of filetype identification will be skipped.}

\item{...}{Arguments for \code{\link{get.config.type}}, 
\code{\link[jsonlite]{fromJSON}}, \code{\link[ini]{read.ini}},
\code{\link[yaml]{yaml.load_file}}, \code{\link[RcppTOML]{parseTOML}}, 
\code{\link{readLines}}}
}
\value{
All values as a list or 
logical FALSE indicating that is not standard JSON/INI/YAML/TOML format file
}
\description{
Read from the file (JSON/INI/YAML/TOML be supported), retreiving all values as a list.
}
\examples{
config.json <- system.file('extdata', 'config.json', package='configr')
config <- read.config(file=config.json)
config.extra.parsed.1 <- read.config(config.json, list(debug = 'TRUE'))
other.config <- system.file('extdata', 'config.other.yaml', package='configr')
config.extra.parsed.2 <- read.config(config.json, list(debug = 'TRUE'), other.config)
}
\seealso{
\code{\link[jsonlite]{fromJSON}} JSON file will read by this

\code{\link[ini]{read.ini}} INI file will read by this

\code{\link[yaml]{yaml.load_file}} YAML file will read by this

\code{\link[RcppTOML]{parseTOML}} TOML file will read by this
}
