% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cn.r
\docType{methods}
\name{cn}
\alias{cn}
\alias{cn,data.frame-method}
\alias{cn_and}
\alias{cn_and,data.frame-method}
\alias{cn_or}
\alias{cn_or,data.frame-method}
\title{Number-aware Strings with Substitution}
\usage{
cn(object, singular, plural = singular)

cn_and(object, singular, plural = singular)

cn_or(object, singular, plural = singular)

\S4method{cn}{data.frame}(object, singular, plural = singular)

\S4method{cn_and}{data.frame}(object, singular, plural = singular)

\S4method{cn_or}{data.frame}(object, singular, plural = singular)
}
\arguments{
\item{object}{An n-vector, or \code{data.frame} with n rows.}

\item{singular}{The string to return if n = 1.}

\item{plural}{The string to return if n is in 0, 2, 3, 4, ...}
}
\description{
\code{cn} combines grammatical number awareness as in \code{\link{ngettext}}
with \code{\link{sprintf}}-like substitution for comma-concatenated text.
}
\details{
Like \code{ngettext}, this function returns one string to be used with a
singular referent and another with a plural referent. \code{cn} chooses
between the two based on the length of its first argument, \code{object}, or
if \code{object} is a \code{data.frame}, its row count.

Two substitions are made \code{sprintf}-style. "\code{\%n}" is replaced with
the number of \code{object}, and "\code{\%c}" is replaced with the
comma-concatenated values of \code{object}, as in \code{\link{cc}}.

\code{cn_and} uses \code{\link{cc_and}} instead of \code{cc}; \code{cn_or}
uses \code{\link{cc_or}}.
}
\seealso{
\link{cc}
}

