% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ct_search.R
\name{ct_search}
\alias{ct_search}
\title{Get UN Comtrade data}
\usage{
ct_search(reporters, partners, trade_direction = c("all", "imports",
  "exports", "re_imports", "re_exports"), freq = c("annual", "monthly"),
  start_date = "all", end_date = "all", commod_codes = "TOTAL",
  max_rec = NULL, type = c("goods", "services"),
  url = "https://comtrade.un.org/api/get?")
}
\arguments{
\item{reporters}{Country(s) of interest, as a character vector. Can either
be a vector of country names, or "All" to represent all countries.}

\item{partners}{Country(s) that have interacted with the reporter
country(s), as a character vector. Can either be a vector of country names,
or "All" to represent all countries.}

\item{trade_direction}{Indication of which trade directions on which to
focus, as a character vector. Must either be "all", or a vector containing
any combination of the following: "imports", "exports", "re_imports",
"re_exports". Default value is "all".}

\item{freq}{Time frequency of the returned results, as a character string.
Must be either "annual" or "monthly". Default value is "annual".}

\item{start_date}{Start date of a time period, or "all". Default value is
"all". See "details" for more info on valid input formats when not using
"all" as input.}

\item{end_date}{End date of a time period, or "all". Default value is
"all". See "details" for more info on valid input formats when not using
"all" as input.}

\item{commod_codes}{Character vector of commodity codes, or "TOTAL". Valid
commodity codes as input will restrict the query to only look for trade
related to those commodities, "TOTAL" as input will return all trade
between the indicated reporter country(s) and partner country(s). Default
value is "TOTAL".}

\item{max_rec}{Max number of records returned from each API call, as an
integer. If max_rec is set to NULL, then value is determined by whether or
not an API token has been registered. API cap without a token is 50000,
cap with a valid token is 250000. Default value is NULL. For details on
how to register a valid token, see \code{\link{ct_register_token}}.}

\item{type}{Type of trade, as a character string. Must be either "goods" or
"services". Default value is "goods".}

\item{url}{Base of the Comtrade url string, as a character string. Default
value is "https://comtrade.un.org/api/get?" and should mot be changed
unless Comtrade changes their endpoint url.}
}
\value{
Data frame of Comtrade shipping data.
}
\description{
Make queries to the UN Comtrade API, data is returned as a tidy data frame.
Comtrade is a DB hosted by the United Nations that houses country-level
shipping data. Full API docs can be found here:
\url{https://comtrade.un.org/data/doc/api/}
}
\details{
Basic rate limit restrictions listed below. For details on how to
 register a valid token, see \code{\link{ct_register_token}}. For API docs
 on rate limits, see \url{https://comtrade.un.org/data/doc/api/#Limits}
 \itemize{
 \item Without authentication token: 1 request per second, 100 requests
   per hour (each per IP address).
 \item With valid authentication token: 1 request per second, 10,000
   requests per hour (each per IP address or authenticated user).
 }

 In addition to these rate limits, the API imposes some limits on
 parameter combinations, they are listed below:
 \itemize{
 \item Between params "reporters", "partners", and the query date range (as
   dictated by the two params "start_date" and "end_date"), only one of
   these three may use the catch-all input "All".
 \item For the same group of three ("reporters", "partners", date range),
   if the input is not "All", then the maximum number of input values
   for each is five. For date range, if not using "All", then the
   "start_date" and "end_date" must not span more than five months or five
   years. There is one exception to this rule, if arg "freq" is "monthly",
   then a single year can be passed to "start_date" and "end_date" and the
   API will return all of the monthly data for that year.
 \item For param "commod_codes", if not using input "All", then the maximum
   number of input values is 20 (although "All" is always a valid input).
 }

 This function returns objects with metadata related to the API call that
 can be accessed via \code{\link{attributes}}. The metadata accessible is:
 \itemize{
 \item url: url of the API call.
 \item time_stamp: date-time of the API call.
 \item req_duration: total duration of the API call, in seconds.
 }

 For args \code{start_date} and \code{end_date}, if inputting a date (as
 opposed to the catch-all input "all"), valid input format is dependent on
 the input passed to arg \code{freq}. If \code{freq} is "annual",
 \code{start_date} and \code{end_date} must be either a string w/ format
 "yyyy" or "yyyy-mm-dd", or a year as an integer (so "2016", "2016-01-01",
 and 2016 would all be valid). If \code{freq} is "monhtly",
 \code{start_date} and \code{end_date} must be a string with format
 "yyyy-mm" or "yyyy-mm-dd" (so "2016-02" and "2016-02-01" would both be
 valid).
}
\examples{
\dontrun{
## Example API call number 1:
# All exports from China to South Korea, United States and Mexico over all
# years.
ex_1 <- ct_search(reporters = "China",
                  partners = c("Rep. of Korea", "USA", "Mexico"),
                  trade_direction = "exports")
nrow(ex_1)

## Example API call number 2:
# All shipments related to shrimp between Canada and all other countries,
# between 2011 and 2015.
# Perform "shrimp" query
shrimp_codes <- ct_commodity_lookup("shrimp",
                                    return_code = TRUE,
                                    return_char = TRUE)

# Make API call
ex_2 <- ct_search(reporters = "Canada",
                  partners = "All",
                  trade_direction = "all",
                  start_date = 2011,
                  end_date = 2015,
                  commod_codes = shrimp_codes)
nrow(ex_2)

# Access metadata
attributes(ex_2)$url
attributes(ex_2)$time_stamp
attributes(ex_2)$req_duration
}
}
