% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{cs_projectXY}
\alias{cs_projectXY}
\title{Project Data}
\usage{
cs_projectXY(.data, varX, varY, crs)
}
\arguments{
\item{.data}{A tibble or data frame}

\item{varX}{Name of column containing x coordinate data}

\item{varY}{Name of column containing y coordinate data}

\item{crs}{integer with the EPSG code, or character with proj4string representing the
coordinate reference system}
}
\value{
A \code{sf} object with the crime data projected for mapping.
}
\description{
\code{cs_projectXY} converts STLMPD data into a simple
    features object using the \code{XCoord} and \code{YCoord} columns.
}
\examples{
# load example data
testData <- january2018

# identify missing x and y coordinates
testData <- cs_missingXY(testData, varX = x_coord, varY = y_coord, newVar = missingXY)

# subset to remove missing data
testData <- dplyr::filter(testData, missingXY == FALSE)

# project data
testData_sf <- cs_projectXY(testData, varX = x_coord, varY = y_coord)

# project data and transform to new CRS
testData_sf <- cs_projectXY(testData, varX = x_coord, varY = y_coord, crs = 4269)

}
