% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{cs_missingXY}
\alias{cs_missingXY}
\title{Identify Missing Coordinates}
\usage{
cs_missingXY(.data, varX, varY, newVar)
}
\arguments{
\item{.data}{A tibble or data frame}

\item{varX}{Name of column containing x coordinate data}

\item{varY}{Name of column containing y coordinate data}

\item{newVar}{Name of new column that is \code{TRUE} if coordinate data are
missing and \code{FALSE} otherwise.}
}
\value{
A tibble or data frame with a logical vector appended to it.
}
\description{
\code{cs_missingXY} compares X and Y coordinates and adds a
    logical column that identifies observations that are missing coordinate data.
}
\examples{
# load example data
testData <- january2018

# identify missing x and y coordinates
testData <- cs_missingXY(testData, varX = XCoord, varY = YCoord, newVar = missingXY)

}
