\name{rnorm}
\alias{rnorm.acomp}
\alias{rnorm.rcomp}
\alias{rnorm.aplus}
\alias{rnorm.rplus}
\alias{rnorm.rmult}
\alias{rnorm.ccomp}
\alias{dnorm.acomp}
\alias{dnorm.aplus}
\alias{dnorm.rmult}
\title{Normal distributions on special spaces}
\description{
  \code{rnorm.}\var{X} generates multivariate normal random variates in
  the space \var{X}. 
}
\usage{
rnorm.acomp(n,mean,var)
rnorm.rcomp(n,mean,var)
rnorm.aplus(n,mean,var)
rnorm.rplus(n,mean,var)
rnorm.rmult(n,mean,var)
rnorm.ccomp(n,mean,var,lambda)
dnorm.acomp(x,mean,var,withJacobian=FALSE)
dnorm.aplus(x,mean,var,withJacobian=FALSE)
dnorm.rmult(x,mean,var)
          }
\arguments{
  \item{n}{number of datasets to be simulated}
  \item{mean}{The mean of the dataset to be simulated}
  \item{var}{The variance covariance matrix}
  \item{lambda}{The expected total count}
  \item{x}{vectors in the sampling space}
  \item{withJacobian}{should the jacobian of the log or logratio transformation be included in
  the density calculations? defaults to FALSE (see details)}
}
\value{
  a random dataset of the given class generated by a normal distribution
  with the given mean and
  variance in the given space. For the density functions \code{d*}, the value of the 
  probability density at the values of \code{x} provided}
\details{
  The normal distributions in the various spaces dramatically
  differ. The normal distribution in the \code{rmult} space is the
  commonly known multivariate joint normal distribution. For
  \code{rplus} this distribution has to be somehow truncated at 0. This
  is here done by setting negative values to 0, i.e. this simulation function
  produces a sort of multivariate tobit model.
  \cr
  The normal distribution
  of \code{rcomp} is seen as a normal distribution within the simplex as
  a geometrical portion of the real vector space. The variance is thus
  forced to be singular and restricted to the affine subspace generated
  by the simplex. The necessary truncation of negative values is
  currently done by setting them explicitly to zero and reclosing
  afterwards, again in the fashion of a tobit model. 
  \cr
  The \code{"acomp"} and \code{"aplus"} are themselves metric vector spaces and
  thus a normal distribution is defined in them just as in the real
  space. The resulting distribution almost correspond to multivariate
  lognormal in the case of \code{"aplus"} and Aitchison normal
  distribution in the simplex in the case of \code{"acomp"}. These models
  are equivalent in probability to the multivariate lognormal distribution
  and the addditive logistic normal distribution respectively, albeit without
  including the jacobian of the log or the logratio transformation. If you are 
  interested in the density of the additive logistic normal model, give the extra
  argument \code{withJacobian=TRUE}. If you are interested in the multivariate 
  lognormal density cou can either do the same, or better call \code{\link{dlnorm.rplus}}.
  \cr
  Densities are only provided for the models constructed for \code{rmult}, 
  \code{aplus} and \code{acomp} because they do exist w
  with repect to the Lebesgue measure of each of these spaces. 
  In the other cases it is not possible to compute a measure, since the truncation
  at zero values produce 
  distributions that are not absolutely continuous with respect to the real, conventional 
  Lebesgue measure. 
  \cr
  For count compositions \code{ccomp} a rnorm.acomp is realized and used
  as a parameter to a Poisson distribution (see \code{\link{rpois.ccomp}}). So, this is 
  in reality no normal model, but a double stochastic counting process.
}
\author{K.Gerald v.d. Boogaart \url{http://www.stat.boogaart.de}}
\seealso{
  \code{\link{runif.acomp}}, \code{\link{rlnorm.rplus}},
  \code{\link{rDirichlet.acomp}}

}
\references{
  Aitchison, J. (1986) \emph{The Statistical Analysis of Compositional
    Data} Monographs on Statistics and Applied Probability. Chapman &
  Hall Ltd., London (UK). 416p.\cr

  Pawlowsky-Glahn, V. and J.J. Egozcue (2001) Geometric approach to
  statistical analysis on the simplex. \emph{SERRA} \bold{15}(5), 384-398\cr

  Aitchison, J, C. Barcel'o-Vidal, J.J. Egozcue, V. Pawlowsky-Glahn
  (2002) A consise guide to the algebraic geometric structure of the
  simplex, the sample space for compositional data analysis, \emph{Terra
    Nostra}, Schriften der Alfred Wegener-Stiftung, 03/2003\cr

}
\examples{
MyVar <- matrix(c(
0.2,0.1,0.0,
0.1,0.2,0.0,
0.0,0.0,0.2),byrow=TRUE,nrow=3)
MyMean <- c(1,1,2)

plot(rnorm.acomp(100,MyMean,MyVar))
plot(rnorm.rcomp(100,MyMean,MyVar))
plot(rnorm.aplus(100,MyMean,MyVar))
plot(rnorm.rplus(100,MyMean,MyVar))
plot(rnorm.rmult(100,MyMean,MyVar))
x <- rnorm.aplus(5,MyMean,MyVar)
dnorm.acomp(x,MyMean,MyVar)
dnorm.aplus(x,MyMean,MyVar)
dnorm.rmult(x,MyMean,MyVar)
}
\keyword{distribution}
