% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zlm.wfit.R
\name{rstandard.zlm}
\alias{rstandard.zlm}
\title{Standardized Residuals from Ordinary or Robust Linear fits with Complex Variables}
\usage{
\method{rstandard}{zlm}(model, lever = zhatvalues(model), ...)
}
\arguments{
\item{model}{An object of class "zlm", "rzlm", "lm", or "rlm". Can be complex or numeric.}

\item{lever}{A list of leverage scores with the same length as \code{model$residuals}. By default \link{zhatvalues} is called on \code{model}.}

\item{...}{Other parameters. Only used if \code{model} is numeric; in which case they are passed to \code{stats::rstandard}.}
}
\value{
A complex vector of length equal to that of the residuals of \code{model}. Numeric for numeric input.
}
\description{
Generates a vector of residuals from the given complex linear model that are normalized to have unit variance.
Similar to \link[stats:influence.measures]{stats::rstandard}, which this function calls if given numeric input.
}
\details{
The standardized residuals are calculated as,\cr
\deqn{r' = r / ( s \sqrt(1 - lever) )}\cr
Where \eqn{r} is the residual vector and \eqn{s} is the residual standard error for "zlm" objects
or the robust scale estimate for "rzlm" objects.
}
\note{
This is a much simpler function than \link[stats:influence.measures]{stats::rstandard}.
It cannot perform leave-one-out cross validation residuals, or anything else not mentioned here.
}
\examples{
set.seed(4242)
n <- 8
slop <- complex(real = 4.23, imaginary = 2.323)
interc <- complex(real = 1.4, imaginary = 1.804)
e <- complex(real=rnorm(n)/6, imaginary=rnorm(n)/6)
xx <- complex(real= rnorm(n), imaginary= rnorm(n))
tframe <- data.frame(x = xx, y= slop*xx + interc + e)
fit <- lm(y ~ x, data = tframe, weights = rep(1,n))
rstandard(fit)
}
\seealso{
\link[stats:influence.measures]{stats::rstandard}, \link[stats:influence.measures]{stats::rstandard.lm},
}
