% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{\%gt\%}
\alias{\%gt\%}
\title{Perform greater than comparison between two objects}
\usage{
x1 \%gt\% x2
}
\arguments{
\item{x1}{The first object to compare}

\item{x2}{The second object to compare}
}
\value{
A single TRUE or FALSE value indicating the results of the comparison.
}
\description{
The goal of the comparison operators is to return a TRUE
or FALSE value when any two objects are compared.  The operators provides a
simple, reliable equality check that allows comparing
of NULLs, NA values, and atomic data types without error. This operator
performs a greater than comparison.

For data frames, the operator will compare all values in all columns, and return
a single TRUE if all values in the second data frame are greater than the
corresponding values in the first data frame.
}
\examples{
# Comparing of NULLs and NA
NULL \%gt\% NULL        # FALSE
NULL \%gt\% NA          # FALSE
NA \%gt\% NA            # FALSE
1 \%gt\% NULL           # FALSE
1 \%gt\% NA             # FALSE

# Comparing of atomic values
1 \%gt\% 1              # FALSE
2 \%gt\% 1              # TRUE
1 \%gt\% 2              # FALSE
"one" \%gt\% "one"      # FALSE
1 \%gt\% "one"          # FALSE
1 \%gt\% Sys.Date()     # FALSE
Sys.Date() \%gt\% 1     # TRUE (Sys.Date() is a number)

# Comparing of vectors
v1 <- c(0, 1, 2)
v2 <- c(1, 2, 3)
v3 <- c(2, 3, 4)
v1 \%gt\% v1            # FALSE
v1 \%gt\% v2            # FALSE
v2 \%gt\% v1            # TRUE
v3 \%gt\% v1            # TRUE

# Comparing of data frames
d1 <- data.frame(A = v1, B = v2)
d2 <- data.frame(A = v2, B = v3)
d1 \%gt\% d1            # FALSE
d1 \%gt\% d2            # FALSE
d2 \%gt\% d1            # TRUE

# Mixing it up
d1 \%gt\% NULL          # FALSE
v1 \%gt\% d1            # FALSE
1 \%gt\% v1             # FALSE
}
\seealso{
Other operators: 
\code{\link{\%eq\%}()},
\code{\link{\%ge\%}()},
\code{\link{\%le\%}()},
\code{\link{\%lt\%}()},
\code{\link{\%ne\%}()},
\code{\link{\%p\%}()}
}
\concept{operators}
