% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shell_script.R
\name{shell_script}
\alias{shell_script}
\title{Create a Shell Script}
\usage{
shell_script(
  path_files,
  dir_shell = NULL,
  name_shell = "workflow.sh",
  overwrite = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{path_files}{A path from \code{dir_shell} to a
directory with R scripts containing
calls to \code{\link[=cmd_assign]{cmd_assign()}}.}

\item{dir_shell}{The directory where
\code{shell_script()} will create the shell script.
If no value is supplied, then \code{shell_script()}
creates the shell script in the current working directory.}

\item{name_shell}{The name of the shell script.
The default is \code{"workflow.sh"}.}

\item{overwrite}{Whether to overwrite
an existing shell script. Default is \code{FALSE}.}

\item{quiet}{Whether to suppress
progress messages. Default is \code{FALSE}.}
}
\value{
\code{shell_script()} is called for its
side effect, which is to create a
file. However, \code{shell_script()} also
returns a string with the contents of the
shell script.
}
\description{
Create a shell script for a data analysis workflow
consisting of commands
extracted from existing R files.
}
\details{
To create a shell script in the \code{files}
directory, set \code{files} to \code{"."}.

To obtain the contents of the shell script
without creating a file on disk,
creating the file on disk, set
\code{name_shell} to \code{NULL}.

Supplying a value for \code{files} is
compulsory for \code{shell_script()},
but optional for \code{\link[=makefile]{makefile()}}.
The output from \code{shell_script()}
is generated entirely from \code{files}
while the output from \code{\link[=makefile]{makefile()}}
also includes some general-purpose Makefile
commands.
}
\examples{
library(fs)
library(withr)

with_tempdir({

  ## create 'src'  directory
  dir_create("src")

  ## put R scripts containing calls to
  ## 'cmd_assign' in the 'src' directory
  writeLines(c("cmd_assign(x = 1, .out = 'out/results.rds')",
               "results <- x + 1",
               "saveRDS(results, file = .out)"),
             con = "src/results.R")
  writeLines(c("cmd_assign(x = 1, .out = 'out/more_results.rds')",
               "more_results <- x + 2",
               "saveRDS(more_results, file = .out)"),
             con = "src/more_results.R")

  ## call 'shell_script()'
  shell_script(path_files = "src",
               dir_shell = ".")

  ## shell script has been created
  dir_tree()

  ## print contents of shell script
  cat(readLines("workflow.sh"), sep = "\n")

})
}
\references{
\itemize{
\item Episodes 1--3 of \href{https://swcarpentry.github.io/shell-novice/index.html}{The Unix Shell}
Introduction to the command line
\item \href{https://swcarpentry.github.io/r-novice-inflammation/05-cmdline.html}{Command-Line Programs}
Introduction to Rscript
}
}
\seealso{
\itemize{
\item \href{https://bayesiandemography.github.io/command/articles/a2_shell_script.html}{Creating a Shell Script} More on \code{shell_script()}
\item \code{\link[=extract_shell]{extract_shell()}} Turn a \code{\link[=cmd_assign]{cmd_assign()}} call into a shell command
\item \code{\link[=makefile]{makefile()}} Makefile equivalent of \code{shell_script()}
\item \code{\link[=cmd_assign]{cmd_assign()}} Process command line arguments
\item \href{https://bayesiandemography.github.io/command/articles/workflow.html}{Modular Workflows for Data Analysis}
Safe, flexible data analysis workflows
\item \href{https://CRAN.R-project.org/package=littler}{littler} Alternative to Rscript
}
}
