% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorspace.R
\name{writehex}
\alias{writehex}
\title{Write Hexadecimal Color Descriptions}
\usage{
writehex(x, file = "")
}
\arguments{
\item{x}{a color object.}

\item{file}{the name of the file to be written.}
}
\value{
The name of the file is returned as the value of the function.
}
\description{
Given a color object, this function writes a file containing the hexadecimal
representation of the colors in the object.
}
\details{
This function converts the given color object to RGB and then writes
hexadecimal strings (of the form \code{#RRGGBB}) representing the colors to
the specified file.
}
\examples{
set.seed(1)
x <- RGB(runif(10), runif(10), runif(10))
writehex(x, "random.txt")
}
\seealso{
\code{\link{readhex}}, \code{\link{readRGB}},
\code{\link{hex2RGB}}, \code{\link{RGB}}, \code{\link{HSV}},
\code{\link{XYZ}}, \code{\link{LAB}}, \code{\link{polarLAB}},
\code{\link{LUV}}, \code{\link{polarLUV}}.
}
\author{
Ross Ihaka
}
\keyword{color}
