% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorpatch.R
\docType{package}
\name{colorpatch-package}
\alias{colorpatch}
\alias{colorpatch-package}
\title{A small introduction to the \link{colorpatch} package.}
\description{
The colorpatch package provides functions for plotting \strong{color patch grids} rendering
the two channels fold change and confidence value within a single diagram.
This is especially useful for analyzing gene expression data as well as other types of "change" data
such as gains/losses in stock exchange or analyzing the agricultural output.
}
\details{
The packages consists of:
\itemize{
\item ggplot extensions for visualizing color patch grids \code{\link[colorpatch:stat_colorpatch]{colorpatch::stat_colorpatch()}} and \code{\link[colorpatch:stat_bicolor]{colorpatch::stat_bicolor()}}
\item Functionality for rearranging data for a better readable map \code{\link[colorpatch:OrderData]{colorpatch::OrderData()}}
\item Perceptual optimization functions for sub-sampling non-uniform bicolored palettes \code{\link[colorpatch:OptimizeBiColor]{colorpatch::OptimizeBiColor()}}
}

For more details see the vignette
}
\examples{
vignette("introduction", package = "colorpatch")
}
\seealso{
Useful links:
\itemize{
  \item \url{http://sysbio.uni-ulm.de/?Software:colorpatch}
}

}
\author{
\strong{Maintainer}: Andre Mueller \email{andre@kiwisound.de}

Authors:
\itemize{
  \item Hans Kestler \email{hans.kestler@uni-ulm.de}
}

}
