% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check_dataset}
\alias{check_dataset}
\alias{check.dataset}
\title{check_dataset}
\usage{
check_dataset(d, suffix = "", req = c("type", "snp"), warn.minp = 1e-06)

check.dataset(...)
}
\arguments{
\item{d}{dataset to check}

\item{suffix}{string to identify which dataset (1 or 2)}

\item{req}{names of elements that must be present}

\item{warn.minp}{print warning if no p value < warn.minp}

\item{...}{arguments passed to check_dataset()}
}
\value{
NULL if no errors found
}
\description{
Check coloc dataset inputs for errors
}
\details{
A coloc dataset is a list, containing a mixture of vectors
capturing quantities that vary between snps (these vectors must
all have equal length) and scalars capturing quantities that
describe the dataset.

Coloc is flexible, requiring perhaps only p values, or z scores, or effect
estimates and standard errors, but with this flexibility, also comes
difficulties describing exactly the combinations of items required.

Required vectors are some subset of

\describe{
\item{beta}{regression coefficient for each SNP from dataset 1}
\item{varbeta}{variance of beta}
\item{pvalues}{P-values for each SNP in dataset 1}
\item{MAF}{minor allele frequency of the variants}
\item{snp}{a character vector of snp ids, optional. It will be used to merge dataset1 and dataset2 and will be retained in the results.}
}

Preferably, give \code{beta} and \code{varbeta}.  But if these are not available, sufficient statistics can be approximated from \code{pvalues} and \code{MAF}.

Required scalars are some subset of

\describe{
\item{N}{Number of samples in dataset 1}
\item{type}{the type of data in dataset 1 - either "quant" or "cc" to denote quantitative or case-control}
\item{s}{for a case control dataset, the proportion of samples in dataset 1 that are cases}
\item{sdY}{for a quantitative trait, the population standard deviation of the trait.  if not given, it can be estimated from the vectors of varbeta and MAF}
}

You must always give {\code{type}}.  Then,
\describe{
\item{if \code{type}=="cc"}{\code{s}}
\item{if \code{type}=="quant" and \code{sdY} known}{\code{sdY}}
\item{if beta, varbeta not known}{\code{N}}
}
If \code{sdY} is unknown, it will be approximated, and this will require
\describe{
\item{summary data to estimate \code{sdY}}{\code{beta}, \code{varbeta}, \code{N}, \code{MAF}}
}

Optional vectors are

\describe{
\item{position}{a vector of snp positions, required for \code{plot_dataset}}
}

\code{check_dataset} calls stop() unless a series of expectations on dataset
input format are met

This is a helper function for use by other coloc functions, but
you can use it directly to check the format of a dataset to be
supplied to coloc.abf(), coloc.signals(), finemap.abf(), or
finemap.signals().
}
\author{
Chris Wallace
}
