% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{toy}
\alias{toy}
\title{One response and four predictors with varying levels of multicollinearity}
\format{
Data frame with 2000 rows and 5 columns.
}
\usage{
data(toy)
}
\description{
Data frame with known relationship between responses and predictors useful
to illustrate multicollinearity concepts. Created from \link{vi} using the code
shown in the example.
}
\details{
Columns:
\itemize{
\item \code{y}: response variable generated from \code{a * 0.75 + b * 0.25 + noise}.
\item \code{a}: most important predictor of \code{y}, uncorrelated with \code{b}.
\item \code{b}: second most important predictor of \code{y}, uncorrelated with \code{a}.
\item \code{c}: generated from \code{a + noise}.
\item \code{d}: generated from \code{(a + b)/2 + noise}.
}

These are variance inflation factors of the predictors in \code{toy}.
variable vif
b       4.062
d       6.804
c       13.263
a       16.161
}
\seealso{
Other example_data: 
\code{\link{vi}},
\code{\link{vi_predictors}},
\code{\link{vi_predictors_categorical}},
\code{\link{vi_predictors_numeric}}
}
\concept{example_data}
\keyword{datasets}
