% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify.R
\name{identify_non_numeric_predictors}
\alias{identify_non_numeric_predictors}
\title{Identify non-numeric predictors}
\usage{
identify_non_numeric_predictors(df = NULL, predictors = NULL)
}
\arguments{
\item{df}{(required; data frame) A data frame with numeric and/or character predictors predictors, and optionally, a response variable. Default: NULL.}

\item{predictors}{(optional; character vector) A vector with predictor names in 'df'. If omitted, all columns of 'df' are used as predictors. Default:'NULL'}
}
\value{
character vector with names of numeric predictors.
}
\description{
Given 'df' and 'predictors' arguments, this function subsets and returns the non-numeric (character, factor, and logical) predictors.
}
\examples{

data(
  vi,
  vi_predictors
)

non.numeric.predictors <- identify_non_numeric_predictors(
  df = vi,
  predictors = vi_predictors
)

non.numeric.predictors

}
\author{
Blas M. Benito
}
