% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collindlnm.R
\name{collindlnm}
\alias{collindlnm}
\title{Simulates effects from a distributed lag model
pattern.}
\usage{
collindlnm(model, x, cb, at = 1, cen = 0, effect, type = c("coef",
  "risk"), shape = c("linear", "nonlinear"), nsim = 100,
  verbose = TRUE, seed = NULL)
}
\arguments{
\item{model}{a model that includes a crossbasis. Currently, models allowed are those
of class \code{"glm"} or \code{"lme"}, if \code{shape = "linear"}; or
\code{"glm"}, if \code{shape = "nonlinear"}.}

\item{x}{if \code{shape = "linear"}, a matrix that includes the values of the predictor
under study, in the first column, and the lagged values, up to the maximum lag
considered, as the subsequent columns. If \code{shape = "nonlinear"}, a numeric
vector or 1-column matrix including the original (i.e. lag 0) values of the
predictor.}

\item{cb}{an object of class \code{"crossbasis"}. The crossbasis included in \code{model}.}

\item{at}{the increase(s) in the predictor under study to be considered to report the
effects of the variable. If \code{shape = "linear"}, \code{at} must be a single
number. If \code{shape = "nonlinear"}, \code{at} must be a numeric vector with
at least two different values.}

\item{cen}{a number. Reference value of the predictor under study, used to calculate
effects. If \code{shape = "linear"}, the value of \code{cen} is irrelevant (and
it is internally set to 0).}

\item{effect}{a vector or a matrix, depending on \code{shape}, including the
hypothetical effect of the predictor under analysis. If \code{shape = "linear"},
a vector including the linear effect at each lag (including lag 0). If
\code{shape = "nonlinear"}, a matrix including the effect at each lag (including
lag 0) (columns) and for each value in \code{at} (rows).}

\item{type}{a character. If \code{type = "coef"} (default), \code{effect} is supposed
to be in the linear predictor scale (i.e. it is considered as regression
coefficients in \code{model}). If \code{type = "risk"}, \code{effect} is supposed
to be in terms of relative risks (i.e. exp(\code{coef}), as ORs or RRs in logistic
or Poisson families, respectively). If \code{model} is of class \code{"lme"},
then it must be \code{type = "coef"} (default).}

\item{shape}{the shape of the relationship between the linear predictor of the model
and the outcome. Default is \code{"linear"}.}

\item{nsim}{number of simulations. Default is 100.}

\item{verbose}{a logical value indicating output status messages. Default is \code{TRUE}.}

\item{seed}{a number. Seed for reproducibility of results. Default is \code{NULL} (no
seed).}
}
\value{
A list including the results of the simulations to be passed to the \code{plot}
  method.
}
\description{
Simulates results from a distributed lag model under an hypothetical effect
pattern provided by the user, which can be linear or non-linear. The output
is the passed to the \code{plot} method to visualize consequences of
collinearity.
}
\examples{
# For detailed examples:
browseVignettes("collin")
}
\seealso{
\code{\link[dlnm]{crossbasis}}, \code{\link[stats]{glm}},
  \code{\link[nlme]{lme}}.
}
