% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dict.R
\name{dict}
\alias{dict}
\title{Dictionary}
\usage{
dict(items = NULL, keys = NULL)
}
\arguments{
\item{items}{a list of items}

\item{keys}{a list of keys, use \code{names(items)} if \code{NULL}}
}
\description{
\code{dict} creates an ordinary (unordered) dictionary (a.k.a. hash).
}
\details{
Following methods are exposed:
\preformatted{
.$set(key, value)
.$get(key, default)
.$remove(key)
.$pop(key, default)
.$has(key)
.$keys()
.$values()
.$update(d)
.$clear()
.$size()
.$as_list()
.$print()
}
\itemize{
\item \code{key}: scalar character, environment or function
\item \code{value}: any R object, value of the item
\item \code{default}: optional, the default value of an item if the key is not found
\item \code{d}: a dict object
}
}
\examples{
d <- dict(list(apple = 5, orange = 10))
d$set("banana", 3)
d$get("apple")
d$as_list()  # unordered
d$pop("orange")
d$as_list()  # "orange" is removed
d$set("orange", 3)$set("pear", 7)  # chain methods

# vector indexing
d$set(c(1L, 2L), 3)$set(LETTERS, 26)
d$get(c(1L, 2L))  # 3
d$get(LETTERS)  # 26

# object indexing
e <- new.env()
d$set(sum, 1)$set(e, 2)
d$get(sum)  # 1
d$get(e)  # 2
}
\seealso{
\link{ordered_dict}
}
