% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coi5p.r
\name{translate}
\alias{translate}
\alias{translate.coi5p}
\title{Translate a coi5p sequence.}
\usage{
translate(x, ...)

\method{translate}{coi5p}(x, ..., trans_table = 0, frame_offset = 0)
}
\arguments{
\item{x}{A coi5p class object for which frame() has been run.}

\item{...}{Additional arguments to be passed between methods.}

\item{trans_table}{The translation table to use for translating from nucleotides to amino acids.
Default is 0, which indicates that censored translation should be performed. If the taxonomy
of the sample is known, use the function which_trans_table() to determine the translation table to use.}

\item{frame_offset}{The offset to the reading frame to be applied for translation. By default the offset
is zero, so the first character in the framed sequence is considered the first nucleotide of the first codon.
Passing frame_offset = 1 would offset the sequence by one and therefore make the second character in the
framed sequence the first nucleotide of the first codon.}
}
\value{
An object of class \code{"coi5p"}
}
\description{
Translate a coi5p sequence.
}
\details{
The translate function allows for the translation of framed sequences from nucleotides to amino acids, both
in instances when the correct genetic code corresponding to a sequence is known, and in instances when taxonomic
information is unavailable or unreliable.
}
\examples{
#previously run functions:
dat = coi5p(example_nt_string )
dat = frame(dat)
#translate when the translation table is not known:
dat = translate(dat)
#translate when the translation table is known:
dat = translate(dat, trans_table = 5)
#additional components in output coi5p object:
dat$aaSeq
}
\seealso{
\code{\link{coi5p}}

\code{\link{frame}}

\code{\link{which_trans_table}}
}
