% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr-report.R
\name{ReportICM}
\alias{ReportICM}
\title{Create a serie of reports on Individual Cognitive Maps and quotes}
\usage{
ReportICM(project, output_dir = tempdir(), format = "html")
}
\arguments{
\item{project}{A QDA project, a list as generated by the ProjectCMap function.}

\item{output_dir}{A character string, the output directory of the rendered file (see rmarkdown::render())}

\item{format}{A character string, the format of the report you want. 'html' (default), 'pdf'.}
}
\value{
A cute message.
}
\description{
Create a serie of reports on Individual Cognitive Maps and quotes
##'
Create a serie of reports on Individual Cognitive Maps and quotes. The 'pdf' format will depend on a LaTeX installation. The reports will be stored in a subfolder of your working directory ('./data-output/icm/...').
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

ReportICM(my.project)
## ReportICM(my.project, "pdf") ## need LaTeX to be installed and working with R.
}
