% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Euclid.R
\name{Euclid}
\alias{Euclid}
\title{Calculation of the Euclidean Distance}
\usage{
Euclid(x, y, squared = FALSE)
}
\arguments{
\item{x}{A set of coordinates in the form of a \code{\link{matrix}} or
\code{\link{data.frame}}.}

\item{y}{An optional second set of coordinates in the same dimensions as
argument \code{x}.}

\item{squared}{Should the squared Euclidean distances be returned (default:
FALSE).}
}
\value{
A `\link{dist}-class` object or, whenever \code{y} is provided,
a \code{\link{matrix}} with as many rows as the number of rows in \code{x}
and as many columns as the number of rows in \code{y}.
}
\description{
Function \code{Euclid} carries out the calculation of pairwise Euclidean
distances within a set of coordinates or between two sets thereof, with
optional weights.
}
\details{
When only one set of coordinates is given to the function (i.e.,
when argument \code{y} is omitted), the function returns the pairwise
distances in the form of a `\link{dist}-class` object representing a
lower-triangle matrix. If weights are omitted, the result is identical to
that produced by function \link{dist} with argument
\code{method = "euclidean"} (the function's default).

The standard `R` function used to calculate the Euclidean distance
(\code{\link{dist}}), only allows one to calculate pairwise distances between
the rows of a single matrix of Cartesian coordinates and return a
`\link{dist}-class` object, which is a one-dimensional array meant to be
interpreted as a lower-triangular matrix. Function \code{Euclid} can also be
provided two data matrices (arguments \code{x} and \code{y}) and output a
rectangular matrix of the Euclidean distances.
}
\examples{
## A set of reference points:
x <- cbind(c(1,4,5,2,8,4), c(3,6,7,1,3,2))
dimnames(x) <- list(LETTERS[1:6], c("x", "y"))

## The pairwise Euclidean distances among the reference points: 
d1 <- Euclid(x)
d1

## That result is the same as that obtained from function dist:
d2 <- dist(x, method = "euclidean")
all(d1 == d2)

## A second set of points:
y <- cbind(c(3,5,7), c(3,6,8))
dimnames(y) <- list(LETTERS[7:9], c("x", "y"))

## The distances between the points in y (rows) and x (columns):
Euclid(x, y)

}
\seealso{
The `\link{dist}-class` and associated methods.
}
\author{
\packageAuthor{codep}
Maintainer: \packageMaintainer{codep}
}
