\name{bal.tab.matchit}
\alias{bal.tab.matchit}
\title{
Balance Statistics for \code{MatchIt} Objects
}
\description{
Generates balance statistics for \code{matchit} objects from \pkg{MatchIt}.
}
\usage{
\method{bal.tab}{matchit}(x, 
        stats,
        int = FALSE,
        poly = 1,
        distance = NULL,
        addl = NULL,
        data = NULL,
        continuous,
        binary,
        s.d.denom,
        thresholds = NULL,
        weights = NULL,
        cluster = NULL,
        imp = NULL,
        pairwise = TRUE,
        s.weights = NULL,
        abs = FALSE,
        subset = NULL,
        quick = TRUE,
        method,
        ...)
}

\arguments{
  \item{x}{
a \code{matchit} object; the output of a call to \pkgfun{MatchIt}{matchit}.
}
  \item{stats, int, poly, addl, data, continuous, binary, thresholds, weights, cluster, imp, pairwise, abs, subset, quick, \dots}{
see \fun{bal.tab} for details.

See below for special notes on the \code{distance}, \code{s.d.denom}, and \code{s.weights} arguments.
}
  \item{method}{
a character vector containing the method of adjustment. Ignored unless subclassification was used in the original call to \code{matchit()}. If \code{"weighting"}, the subclassification weights will be used and subclasses will be ignored. If \code{"subclassification"}, balance will be assessed using the subclasses (see \code{\link[=class-bal.tab.subclass]{bal.tab.subclass}} for details). Abbreviations allowed.
}

The following arguments have special notes when used with \code{matchit} objects:
  \item{distance}{
the distance measure (e.g., propensity score) generated by \code{matchit()} is automatically included and named "distance".
}
  \item{s.d.denom}{
if not specified, \code{bal.tab()} will figure out which one is best based on the estimand of the \code{matchit} object: if ATT, \code{"treated"}; if ATC, \code{"control"}, otherwise \code{"pooled"}.
}
  \item{s.weights}{
if \code{s.weights} was supplied in the call to \code{matchit()}, they will automatically be included and do not need be specified again (though there is no harm if they are).
}

}
\details{
\code{bal.tab.matchit()} generates a list of balance summaries for the \code{matchit} object given, and functions similarly to \pkgfun{MatchIt}{summary.matchit}. \code{bal.tab()} behaves differently depending on whether subclasses are used in conditioning or not. If they are used, \code{bal.tab()} creates balance statistics for each subclass and for the sample in aggregate; see \code{\link[=class-bal.tab.subclass]{bal.tab.subclass}} for more information. 
}
\value{
If subclassification is used and \code{method} is set to \code{"subclassification"}, an object of class \code{"bal.tab.subclass"} containing balance summaries within and across subclasses. See \code{\link[=class-bal.tab.subclass]{bal.tab.subclass}} for details.

If matching is used and clusters are not specified, an object of class \code{"bal.tab"} containing balance summaries for the \code{matchit} object. See \fun{bal.tab} for details.

If clusters are specified, an object of class \code{"bal.tab.cluster"} containing balance summaries within each cluster and a summary of balance across clusters. See \code{\link[=class-bal.tab.cluster]{bal.tab.cluster}} for details.
}

\author{
Noah Greifer 
}

\seealso{
\fun{bal.tab} for details of calculations.
}
\examples{\dontshow{if (requireNamespace("MatchIt", quietly = TRUE)) force(\{ # examplesIf}
library(MatchIt); data("lalonde", package = "cobalt")

## Nearest Neighbor matching
m.out1 <- matchit(treat ~ age + educ + race + 
                  married + nodegree + re74 + re75, 
                  data = lalonde, method = "nearest")
                  
bal.tab(m.out1, un = TRUE, m.threshold = .1, 
        v.threshold = 2)

## Subclassification
m.out2 <- matchit(treat ~ age + educ + race + 
                  married + nodegree + re74 + re75, 
                  data = lalonde, method = "subclass")
                  
bal.tab(m.out2, disp.subclass = TRUE)
\dontshow{\}) # examplesIf}}
\keyword{tables}
