% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_recombination.R
\name{feat_recombination}
\alias{feat_recombination}
\title{Feature: Recombination}
\usage{
feat_recombination(rate)
}
\arguments{
\item{rate}{The recombination rate. Can be a numeric or a
\code{\link{parameter}}. The rate is equal to
\eqn{4*N0*r}, where \eqn{r} is the probability that a
recombination event within the locus occurs in one generation.}
}
\value{
The feature, which can be added to a model using `+`.
}
\description{
This feature adds intra-locus recombination to a model.  The rate is per locus
for \link[=locus]{unlinked loci} and per trio for linked
\link[=locus_trio]{locus trios}. By default, the same recombination rate is used
for all loci, but it is possible to change this with \code{\link{par_variation}}
and \code{\link{par_zero_inflation}}. Coala assumes that recombination events
can occur between all neighboring bases.
}
\examples{
# Simulate a 1.5kb sequence for 10 individuals with recombination:
model <- coal_model(10, 2, 1500) +
  feat_recombination(1.5) +
  feat_mutation(5) +
  sumstat_sfs()
simulate(model)
}
\seealso{
For adding recombination: \code{\link{feat_mutation}}.

Other features: \code{\link{feat_growth}},
  \code{\link{feat_ignore_singletons}},
  \code{\link{feat_migration}},
  \code{\link{feat_mutation}}, \code{\link{feat_outgroup}},
  \code{\link{feat_pop_merge}},
  \code{\link{feat_selection}},
  \code{\link{feat_size_change}},
  \code{\link{feat_unphased}}
}

