% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{imageplot}
\alias{imageplot}
\title{Image function for the co-ranking matrix}
\usage{
imageplot(
  Q,
  lwd = 2,
  bty = "n",
  main = "co-ranking matrix",
  xlab = expression(R),
  ylab = expression(Ro),
  col = colorRampPalette(colors = c("gray85", "red", "yellow", "green", "blue"))(100),
  axes = FALSE,
  legend = TRUE,
  ...
)
}
\arguments{
\item{Q}{of class \code{coranking}.}

\item{lwd}{linewidth in legend}

\item{bty}{boxtype of legend}

\item{main}{title of plot}

\item{xlab}{label of the x axis}

\item{ylab}{label of the y axis}

\item{col}{a palette for coloring}

\item{axes}{ligical draw axes}

\item{legend}{if \code{T} plot a legend.}

\item{...}{parameters for the \code{\link[graphics]{image}} function.}
}
\description{
Plots the co-ranking matrix nicely
}
\details{
Plots the co-ranking matrix nicely for visual inspection.  uses the
\code{image} function internaly, \code{...} is passed down to the image
function. The values in the co-ranking matrix are logscaled for
better contrast.
}
\author{
Guido Kramer
}
