% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment.R
\name{get_seg_scale}
\alias{get_seg_scale}
\title{Change the sacle of a segment}
\usage{
get_seg_scale(segments, nseg, out_length)
}
\arguments{
\item{segments}{list with basis segments and their corresponding indices in the original profile, obtianed by \code{get_segs()}}

\item{nseg}{integer. \code{nseg} = 3: increase the length of the third basis segment.}

\item{out_length}{integer. The length of the enlarged segment}
}
\value{
list consisting of
\itemize{
\item \code{aug_seg}: the increased segment
\item \code{aug_idx}: the corresponding indices in the profile
}
}
\description{
In order to identify the congruent registration position of a basis segment,
the length of the basis segment will be doubled to compute the correlation curve.
\code{get_seg_scale} computes the increased segment, which has the same center
as the basis segment.
}
\examples{
data("bullets")
land2_3 <- bullets$sigs[bullets$bulletland == "2-3"][[1]]
x <- land2_3$sig

segments <- get_segs(x, len = 50)
seg5_scale3 <- get_seg_scale(segments, nseg = 5, out_length = 50)
}
