% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bvp.R
\name{bvp}
\alias{bvp}
\alias{bvpexample}
\alias{bvpexample10}
\title{Boundary value problems}
\usage{
bvpexample(x)

bvpexample10(x)
}
\arguments{
\item{x}{proposed initial \code{x}-value}
}
\value{
a data frame of \code{x} and \code{y} values
}
\description{
solve boundary value problems for ordinary differential equations
}
\details{
The \code{euler} method implements the Euler method for solving
differential equations.  The code{midptivp} method solves initial
value problems using the second-order Runge-Kutta method.  The
\code{rungekutta4} method is the fourth-order Runge-Kutta method.
}
\examples{
bvpexample(-2)
bvpexample(-1)
bvpexample(0)
bvpexample(1)
bvpexample(2)
## (bvp.b <- bisection(bvpexample, 0, 1))
## (bvp.s <- secant(bvpexample, 0))

}

