% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other.R
\name{drop.nonessential.matrices}
\alias{drop.nonessential.matrices}
\title{Drop matrices that are not used for prediction}
\usage{
drop.nonessential.matrices(model, drop_precomputed = TRUE)
}
\arguments{
\item{model}{A model object as returned by \link{CMF} or \link{CMF_implicit}.}

\item{drop_precomputed}{Whether to drop the less commonly used prediction
matrices (see documentation above for more details).}
}
\value{
The model object with the non-essential matrices dropped.
}
\description{
Drops all the matrices in the model object which are not
used for calculating new user factors (either warm or cold), such as the
user biases or the item factors.

This is intended at decreasing memory usage in production systems which
use this software for calculation of user factors or top-N recommendations.

Can additionally drop some of the precomputed matrices which are only
taken in special circumstances such as when passing dense data with
no missing values - however, predictions that would have otherwise used
these matrices will become slower afterwards.

After dropping these non-essential matrices, it will not be possible
anymore to call certain methods such as `predict` or `swap.users.and.items`.
The methods which are intended to continue working afterwards are:\itemize{
\item \link{factors_single}
\item \link{factors}
\item \link{topN_new}
}

This method is only available for `CMF` and `CMF_implicit` model objects.
}
\details{
After calling this function and reassigning the output to the
original model object, one might need to call the garbage collector (by
running `gc()`) before any of the freed memory is shown as available.
}
