% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/items.R
\name{predict_new_items}
\alias{predict_new_items}
\title{Predict new columns of `X` given item attributes}
\usage{
predict_new_items(
  model,
  user,
  item = NULL,
  transX = NULL,
  weight = NULL,
  I = NULL,
  I_bin = NULL
)
}
\arguments{
\item{model}{A collective matrix factorization model from this package - see
\link{fit_models} for details.}

\item{user}{User(s) for which the new entries will be predicted. If passing
a single ID, will calculate all the values in `item`, or all the values in
`I`/`t(X)` (see section `Description` for details).

If the `X` to which the model was fit was a `data.frame`, the IDs here should
match with the IDs of that `X` (its first column). Otherwise, should match with
the rows of `X` (the one to which the model was fit)
with numeration starting at 1 (should be an integer vector).}

\item{item}{Rows of `I`/`transX` (unseen columns of a new `X`) for which to make
predictions, with numeration starting at 1 (should be an integer vector).
See `Description` for details.}

\item{transX}{New `X` data for the items, transposed so that items denote rows
and columns correspond to old users (which were in the `X` to which the model was fit).
Note that the function will not do any reindexing - if the `X` to which the model
was fit was a `data.frame`, the user numeration can be found under
`model$info$user_mapping`.

Can be passed in the following formats:\itemize{
\item A sparse COO/triplets matrix, either from package
`Matrix` (class `dgTMatrix`), or from package `SparseM` (class `matrix.coo`).
\item A sparse matrix in CSR format, either from package
`Matrix` (class `dgRMatrix`), or from package `SparseM` (class `matrix.csr`).
Passing the input as CSR is faster than COO as it will be converted internally.
\item A sparse row vector from package `Matrix` (class `dsparseVector`).
\item A dense matrix from base R (class `matrix`), with missing entries set as NA.
\item A dense vector from base R (class `numeric`).
\item A `data.frame`.
}}

\item{weight}{Associated observation weights for entries in `transX`. If passed, must
have the same shape as `transX` - that is, if `transX` is a sparse matrix, should be a
numeric vector with length equal to the non-missing elements, if `transX` is a dense
matrix, should also be a dense matrix with the same number of rows and columns.}

\item{I}{New `I` data, with rows denoting new columns of the `X` matrix
(the one to which the model was fit) and/or rows of `transX`.
Can be passed in the same formats as `transX`, or additionally as a `data.frame`.}

\item{I_bin}{New binary columns of `I`. Must be passed as a dense matrix from
base R or as a `data.frame`.}
}
\value{
A numeric vector with the predicted value for each requested combination
of (user, item). Invalid combinations will be filled with NAs.
}
\description{
Calculate the predicted values for new columns of `X` (which were
not present in the `X` to which the model was fit) given new `X` and/or `I` data.

This function can predict combinations in 3 ways:\itemize{
\item If passing vectors for `user` and `item`, will predict the combinations
of user/item given in those arrays (e.g. if `I` has 3 rows, and passing
`user=c(1,1,2), item=c(1,2,3)`, will predict entries X[1,1], X[1,2], X[2,3],
with columns of `X` (rows of `t(X)`) corresponding to the rows of `I`
passed here and users corresponding to the ones to which the model was fit).
\item If passing a vector for `user` but not for `item`, will predict the
value that each user would give to the corresponding row of `I`/`t(X)` (in this
case, the number of entries in `user` should be the same as the number of
rows in `I`/`t(X)`).
\item If passing a single value for `user`, will calculate all predictions
for that user for the rows of `I`/`t(X)` given in `item`, or for all rows of
`I`/`t(X)` if `item` is not given.
}

Be aware that the package is user/row centric, and this function is provided for
quick experimentation purposes only. Calculating item factors will be slower
than calculating user factors as it will not make usage of the precomputed
matrices (except for the `ContentBased` model for which both types of predictions
are equally fast and equally supported).
If item-based  predictions are required, it's recommended to use
instead the function \link{swap.users.and.items} and then use the resulting
object with \link{predict_new}.
}
\seealso{
\link{item_factors} \link{predict.cmfrec} \link{predict_new}
}
