#' DNA Methylation, childhood trauma, and stress response
#'
#' A dataset containing variables on childhood trauma, stress response, and 1000 preprocessed epigenetic methylation values. This dataset was synthesised using the \code{synthpop} package to remove any identifying information.
#'
#' @format A data frame with 85 rows and 1002 variables: a composite score on a childhood trauma questionnaire (x), a measure of increase in area under the curve of cortisol after stress task (y), and beta values of methylation at 1000 different locations in the genome.
#' @references {
#' Houtepen, L. C., Vinkers, C. H., Carrillo-Roa, T., Hiemstra, M., Van Lier, P. A., Meeus, W., ... & Schalkwyk, L. C. (2016). Genome-wide DNA methylation levels and altered cortisol stress reactivity following childhood trauma in humans. \emph{Nature communications}, 7, 10967.
#' 
#' van Kesteren, E. J., & Oberski, D. L. (2018). Exploratory Mediation Analysis with Many Potential Mediators. \emph{arXiv preprint} arXiv:1810.06334.
#' }
"methylation"