% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmf.R
\name{cmf}
\alias{cmf}
\title{Coordinate-wise Mediation Filter}
\usage{
cmf(x, M, y, decisionFunction = "prodcoef", nStarts = 1000,
  nCores = "auto", cutoff = 0.5, maxIter = 25, stableLag = 5,
  pb = TRUE, ...)
}
\arguments{
\item{x}{exogenous variable; numeric vector or data frame with x, y, and at
least one M column}

\item{M}{potential mediators; data frame with column names}

\item{y}{outcome variable; numeric vector}

\item{decisionFunction}{either a function with as inputs x, m, y, parameters,
and as output a TRUE (include) or FALSE (exclude) statement or a string
indicating the built-in decision function to use (see details)}

\item{nStarts}{how many times to start the algorithm}

\item{nCores}{how many threads (cores) to use for parallel processing}

\item{cutoff}{a cutoff value for selection: variables are selected if they
display a selection rate higher than this value. Only relevant when multiple
starts are specified. Can also be specified post-hoc using
\code{\link{setCutoff}}.}

\item{maxIter}{the maximum number of iterations for each start}

\item{stableLag}{how long does the selection need to be stable before
deciding the algorithm has converged}

\item{pb}{Whether to display a progress bar (default TRUE). Only available 
with built-in decision functions}

\item{...}{parameters passed to decisionFunction}
}
\value{
an object of class \code{cmf}. See \code{\link{cmf-methods}}
}
\description{
This function performs CMF on a set of potential mediators, given an input
and an output variable. It selects those mediators that are deemed relevant
by a default or a user-defined decision function, *conditional* on the other
mediators in the model. By doing this cyclically, and with multiple random
starts, the algorithm outputs an estimate of the best mediators.
}
\details{
Available decision functions. These functions are implemented in 
C++ to speed up computation. Between brackets the additional parameter that 
may be passed to the function in the \code{...} argument of this function. 
(\code{arguments} = \code{defaultvalue}):

 - \code{prodcoef} (\code{p.value} = 0.1): Test for the product of 
 coefficients, Sobel test
 
 - \code{causalsteps} (\code{p.value} = 0.1): Causal steps test min(Ta, Tb)
}
\examples{
# generate some data
dat <- generateMed(a = (1:10)/20, b = (1:10)/20)
# Run CMF on this data
cmf(dat)

}
