% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decision.R
\name{decision_highCMC_identifyHighCMCThetas}
\alias{decision_highCMC_identifyHighCMCThetas}
\title{Classify theta values in CMC-theta distribution as having "High" or "Low" CMC
candidate counts}
\usage{
decision_highCMC_identifyHighCMCThetas(cmcThetaDistrib, tau = 1)
}
\arguments{
\item{cmcThetaDistrib}{output of the decision_highCMC_cmcThetaDistrib function}

\item{tau}{constant used to define a "high" CMC count. This number is
subtracted from the maximum CMC count achieved in the CMC-theta
distribution. Theta values with CMC counts above this value are considered
to have "high" CMC counts.}
}
\value{
A vector of the same length as the input containing "High" or "Low"
classification based on whether the associated theta value has a High CMC
Candidate count.
}
\description{
Classify theta values in CMC-theta distribution as having "High" or "Low" CMC
candidate counts
}
\note{
This function is a helper internally called in the decision_CMC
function. It is exported to be used as a diagnostic tool for the High CMC
method
}
\examples{
\dontrun{
data(fadul1.1_processed,fadul1.2_processed)

comparisonDF <- purrr::map_dfr(seq(-30,30,by = 3),
                              ~ comparison_allTogether(fadul1.1_processed,
                                                       fadul1.2_processed,
                                                       theta = .))

highCMCthetas <- comparisonDF \%>\%
dplyr::mutate(cmcThetaDistribClassif = decision_highCMC_cmcThetaDistrib(cellIndex = cellIndex,
                                                                 x = x,
                                                                 y = y,
                                                                 theta = theta,
                                                                 corr = pairwiseCompCor)) \%>\%
decision_highCMC_identifyHighCMCThetas(tau = 1)


highCMCthetas \%>\%
dplyr::filter(cmcThetaDistribClassif == "CMC Candidate") \%>\%
ggplot2::ggplot(ggplot2::aes(x = theta,fill = thetaCMCIdentif)) +
ggplot2::geom_bar(stat = "count")
}
}
