% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preProcess.R
\name{preProcess_removeTrend}
\alias{preProcess_removeTrend}
\title{Level a breech face impression surface matrix by a conditional statistic}
\usage{
preProcess_removeTrend(x3p, statistic = "mean", ...)
}
\arguments{
\item{x3p}{an x3p object containing the surface matrix of a cartridge case
scan}

\item{statistic}{either "mean" or "quantile"}

\item{...}{arguments to be set in the quantreg::rq function if statistic =
"quantile" is set. In this case, tau = .5 and method = "fn" are recommended}
}
\value{
an x3p object containing the leveled cartridge case scan surface
matrix.
}
\description{
Level a breech face impression surface matrix by a conditional statistic
}
\examples{

#Process fadul1.1 "from scratch" (takes > 5 seconds to run)
\dontrun{
nbtrd_link <- "https://tsapps.nist.gov/NRBTD/Studies/CartridgeMeasurement/"
fadul1.1_link <- "DownloadMeasurement/2d9cc51f-6f66-40a0-973a-a9292dbee36d"

fadul1.1 <- x3ptools::read_x3p(paste0(nbtrd_link,fadul1.1_link))
fadul1.1_extCropped <- preProcess_crop(x3p = fadul1.1,
                                       region = "exterior",
                                       radiusOffset = -30)

fadul1.1_intCroped <- preProcess_crop(x3p = fadul1.1_extCropped,
                                      region = "interior",
                                      radiusOffset = 200)

fadul1.1_leveled <- preProcess_removeTrend(x3p = fadul1.1_intCroped,
                                           statistic = "quantile",
                                           tau = .5,
                                           method = "fn")

x3pListPlot(list("Original" = fadul1.1,
                 "Ext. Cropped" = fadul1.1_extCropped,
                 "Ext. & Int. Cropped" = fadul1.1_intCroped,
                 "Cropped and Leveled" = fadul1.1_leveled))
}
}
