% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numberOfSorters.R
\name{numberOfSorters}
\alias{numberOfSorters}
\title{Count the Number of Sorters in Concept Map Data}
\usage{
numberOfSorters(CMData, verbose = TRUE)
}
\arguments{
\item{CMData}{A data frame containing concept map data. This must include a column named \code{"sorterID"}.}

\item{verbose}{A logical, if \code{TRUE}, the function will print the number of sorters.}
}
\value{
An integer representing the number of unique sorters in the dataset.
}
\description{
This function calculates the number of unique sorters (users) in a given concept mapping dataset.
}
\details{
The function first checks if the provided dataset is suitable for concept mapping using the \cr
\code{checkConceptMapData} function. If the data is valid, it calculates and returns the number
of unique \code{sorterID}s.
}
\examples{
# Example of valid data
CMData <- data.frame(
    sorterID = c("resp1", "resp1", "resp1", "resp2",
     "resp2", "resp2", "resp3", "resp3", "resp3"),
   statement = c("London", "Frankfurt", "Berlin", "London",
    "Frankfurt", "Berlin", "London", "Frankfurt", "Berlin"),
    stackID = c("capital city", "city", "capital city", 1, 2, 2, "A", "B", "A")
)

# Count the number of sorters silently
numberOfSorters(CMData, verbose = FALSE)

# Count the number of sorters with message
numberOfSorters(CMData)

}
