% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustree_overlay.R
\name{plot_overlay_side}
\alias{plot_overlay_side}
\title{Plot overlay side}
\usage{
plot_overlay_side(
  nodes,
  edges,
  points,
  prefix,
  side_value,
  graph_attr,
  node_size_range,
  edge_width,
  use_colour,
  alt_colour,
  point_size,
  point_alpha,
  point_shape,
  label_nodes,
  label_size,
  y_jitter,
  y_offset
)
}
\arguments{
\item{nodes}{data.frame describing nodes}

\item{edges}{data.frame describing edges}

\item{points}{data.frame describing points}

\item{prefix}{string indicating columns containing clustering information}

\item{side_value}{string giving the metadata column to use for the x axis}

\item{graph_attr}{list describing graph attributes}

\item{node_size_range}{numeric vector of length two giving the maximum and
minimum point size for plotting nodes}

\item{edge_width}{numeric value giving the width of plotted edges}

\item{use_colour}{one of "edges" or "points" specifying which element to
apply the colour aesthetic to}

\item{alt_colour}{colour value to be used for edges or points (whichever is
NOT given by \code{use_colour})}

\item{point_size}{numeric value giving the size of sample points}

\item{point_alpha}{numeric value giving the alpha of sample points}

\item{point_shape}{numeric value giving the shape of sample points}

\item{label_nodes}{logical value indicating whether to add labels to
clustering graph nodes}

\item{label_size}{numeric value giving the size of node labels is
\code{label_nodes} is \code{TRUE}}

\item{y_jitter}{numeric value giving the y-direction spread of
points in side plots}

\item{y_offset}{numeric value giving the y-direction offset for
points in side plots}
}
\value{
ggplot object
}
\description{
Plot the side view of a clustree overlay plot. If the ordinary plot shows the
tree from above this plot shows it from the side, highlighting either the
x or y dimension and the clustering resolution.
}
