% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{sim_seurat}
\alias{sim_seurat}
\title{Seurat Clustered simulated scRNA-seq dataset}
\format{\code{sim_seurat} is a \link[Seurat:seurat]{Seurat::seurat} object holding a simulated
scRNA-seq dataset. The dataset has been clustered using the \code{Seurat} package
with a range of values for the resolution parameter. The results of the
clustering are held in the \code{meta.data} slot with columns named \code{res.X} where
\code{X} is the value of the resolution parameter.}
\source{
\preformatted{# Simulation
library("splatter") # Version 1.2.1

sim <- splatSimulate(batchCells = 200, nGenes = 10000,
                     group.prob = c(0.4, 0.2, 0.2, 0.15, 0.05),
                     de.prob = c(0.1, 0.2, 0.05, 0.1, 0.05),
                     method = "groups", seed = 1)
sim_counts <- counts(sim)[1:1000, ]

library("Seurat") # Version 2.2.0
sim_seurat <- CreateSeuratObject(sim_counts)
sim_seurat <- NormalizeData(sim_seurat, display.progress = FALSE)
sim_seurat <- FindVariableGenes(sim_seurat, do.plot = FALSE,
                                display.progress = FALSE)
sim_seurat <- ScaleData(sim_seurat, display.progress = FALSE)
sim_seurat <- RunPCA(sim_seurat, do.print = FALSE)
sim_seurat <- FindClusters(sim_seurat, dims.use = 1:6,
                           resolution = seq(0, 1, 0.1),
                           print.output = FALSE)
}
}
\usage{
sim_seurat
}
\description{
A simulated scRNA-seq dataset generated using the \code{splatter} package and
clustered using \code{Seurat}.
}
\keyword{datasets}
