# ===========================================================================
# File: "runit_all_int.R"
#                        Created: 2012-11-06 20:02:30
#              Last modification: 2012-11-06 20:02:30
# Author: Bernard Desgraupes
# e-mail: <bdesgraupes@users.sourceforge.net>
# Unit test file for the R package clusterCrit.
# ===========================================================================



test.all_internal_criteria <- function() {
	dataPath <- file.path(path.package(package="clusterCrit"),"unitTests","data","testsInternal_400_4.Rdata")
	load(file=dataPath, envir=.GlobalEnv)
	idx <- intCriteria(traj_400_4, part_400_4[[4]], "all")
	
	cnames <- tolower(getCriteriaNames(TRUE))
	values <- c(0.264855324859755,
		    -534.545225046529,
		    7.0592193043113e-06,
		    3959.80613603063,
		    0.212623030978125,
		    964.208175287163,
		    0.835485600869118,
		    -0.99999988079071,
		    0.373117878591837,
		    0.835485600869118,
		    5.2302461254624,
		    1.86222124332669,
		    2.52634597853241,
		    15.8152471473492,
		    5.63099489006396,
		    1.78341037894133,
		    11.1643758011678,
		    3.97505916293356,
		    1.7678259229192,
		    11.0668151243083,
		    3.94032283110461,
		    0.194633379133716,
		    1.21842970847231,
		    0.433820059742769,
		    44740.3406899463,
		    2748.52288830593,
		    3.40114842491597,
		    0.141800605341339,
		    78.0903473036081,
		    -1.6928719863069,
		    0.017348560185186,
		    0.491870539886729,
		    -1627.96174403586,
		    0.0323239791483279,
		    0.424825246347848,
		    0.0323239791483279,
		    0.827206253180689,
		    -0.610833639021322,
		    105.942129943902,
		    60.2027688244469,
		    0.877070546494266,
		    0.0776720010784792
		    )
	
	result <- as.list(values)
	names(result) <- cnames
	
# 	cat(paste("\nFound idx =",idx))
# 	cat(paste("\nShould be =",result,"\n"))
	checkEquals(idx,result)
}


