# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

TPR_coms_Rcpp <- function(triangles, com) {
    .Call('_clustAnalytics_TPR_coms_Rcpp', PACKAGE = 'clustAnalytics', triangles, com)
}

triangle_participation_ratio_Rcpp <- function(EdgeList) {
    .Call('_clustAnalytics_triangle_participation_ratio_Rcpp', PACKAGE = 'clustAnalytics', EdgeList)
}

print_Rcpp <- function(M) {
    invisible(.Call('_clustAnalytics_print_Rcpp', PACKAGE = 'clustAnalytics', M))
}

#' Estimates |H_i|/|H_{i+1}|
#' 
#' Estimates the fraction of elements of H_i that are also in H_{i+1} (where i=(k,l))
#' @param M matrix
#' @param k,l Coordinates of the first element that is not invariant 
#' @param error error for the convergence of the method
#' @return value of H_i/H_{i+1}
NULL

#' Performs a step of the Markov Chain Monte Carlo method
#' 
#' Modifies the matrix while keeping the column and row sums constant, as well as
#' leaving the positions strictly preceding (k,l) in lexicographical order invariant.
#' 
#' @param M matrix
#' @param k,l Coordinates of the first element that is not invariant 
#' @return boolean indicating whether the step left the matrix invariant
#' @keywords internal
walk_step <- function(M, k, l) {
    .Call('_clustAnalytics_walk_step', PACKAGE = 'clustAnalytics', M, k, l)
}

#' Estimates |H_0|/|H_r*|
#' 
#' This is the total number of contingency tables (of the same margins as M) divided 
#' by the number that match M until the r-th row (included, 0-indexed). Note that
#' if r==0, this is always 1 by definition. 
#' @param M contingency table
#' @param r row index
#' @param error error for the convergence of the method
estimate_H_fraction_r_rows <- function(M, r, error = 0.1) {
    .Call('_clustAnalytics_estimate_H_fraction_r_rows', PACKAGE = 'clustAnalytics', M, r, error)
}

#' Estimates |H_i|/|H_{i+1}| for the first r rows
#' 
#' The product of all these ratios is is the total number of contingency tables (of the same margins as M) divided 
#' by the number that match M until the r-th row (included, 0-indexed). 
#' @param M contingency table
#' @param r row index
#' @param error error for the convergence of the method
#' @return NumericVector containing all the ratios
#' @keywords internal
estimate_H_fractions <- function(M, r, error = 0.1) {
    .Call('_clustAnalytics_estimate_H_fractions', PACKAGE = 'clustAnalytics', M, r, error)
}

#' Contingency table from membership vectors
#' 
#' Given two membership vectors, returns the corresponding contingency table.
#' we assume the labels are >=1 and numbered consecutively. If not consecutive
#' (some labels are unused) this implementation still works, but will be less
#' efficient.
#' @param c1,c2 membership vectors (integer values containing the index of each community)
#' @keywords internal
c_rs_table <- function(c1, c2) {
    .Call('_clustAnalytics_c_rs_table', PACKAGE = 'clustAnalytics', c1, c2)
}

count_labels <- function(c) {
    .Call('_clustAnalytics_count_labels', PACKAGE = 'clustAnalytics', c)
}

mutual_information_Cpp <- function(c1, c2, a, b) {
    .Call('_clustAnalytics_mutual_information_Cpp', PACKAGE = 'clustAnalytics', c1, c2, a, b)
}

vector_c_rs <- function(c1, c2) {
    .Call('_clustAnalytics_vector_c_rs', PACKAGE = 'clustAnalytics', c1, c2)
}

resampled_edgelist <- function(el, s) {
    .Call('_clustAnalytics_resampled_edgelist', PACKAGE = 'clustAnalytics', el, s)
}

randomize <- function(EdgeList, Q, weight_sel = "const_var", lower_bound = 0, upper_bound = -1, directed = FALSE) {
    .Call('_clustAnalytics_randomize', PACKAGE = 'clustAnalytics', EdgeList, Q, weight_sel, lower_bound, upper_bound, directed)
}

cluster_auxiliary_values_Rcpp <- function(EdgeList, memb) {
    .Call('_clustAnalytics_cluster_auxiliary_values_Rcpp', PACKAGE = 'clustAnalytics', EdgeList, memb)
}

density_ratio_Rcpp <- function(aux_vals) {
    .Call('_clustAnalytics_density_ratio_Rcpp', PACKAGE = 'clustAnalytics', aux_vals)
}

local_density_ratio_Rcpp <- function(aux_vals) {
    .Call('_clustAnalytics_local_density_ratio_Rcpp', PACKAGE = 'clustAnalytics', aux_vals)
}

FOMD_Rcpp <- function(EdgeList, memb) {
    .Call('_clustAnalytics_FOMD_Rcpp', PACKAGE = 'clustAnalytics', EdgeList, memb)
}

out_degree_fractions_Rcpp <- function(EdgeList, memb) {
    .Call('_clustAnalytics_out_degree_fractions_Rcpp', PACKAGE = 'clustAnalytics', EdgeList, memb)
}

clustering_coefficient_Rcpp <- function(EdgeList, lower_bound = 0, upper_bound = 1) {
    .Call('_clustAnalytics_clustering_coefficient_Rcpp', PACKAGE = 'clustAnalytics', EdgeList, lower_bound, upper_bound)
}

transitivity_Rcpp <- function(EdgeList, lower_bound = 0, upper_bound = 1) {
    .Call('_clustAnalytics_transitivity_Rcpp', PACKAGE = 'clustAnalytics', EdgeList, lower_bound, upper_bound)
}

