/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.services.elasticbeanstalk.model.AutoScalingGroup;
import com.amazonaws.services.elasticbeanstalk.model.Instance;
import com.amazonaws.services.elasticbeanstalk.model.LaunchConfiguration;
import com.amazonaws.services.elasticbeanstalk.model.LoadBalancer;
import com.amazonaws.services.elasticbeanstalk.model.Trigger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentResourceDescription {
    private String environmentName;
    private List<AutoScalingGroup> autoScalingGroups;
    private List<Instance> instances;
    private List<LaunchConfiguration> launchConfigurations;
    private List<LoadBalancer> loadBalancers;
    private List<Trigger> triggers;

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public EnvironmentResourceDescription withEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
        return this;
    }

    public List<AutoScalingGroup> getAutoScalingGroups() {
        if (this.autoScalingGroups == null) {
            this.autoScalingGroups = new ArrayList<AutoScalingGroup>();
        }
        return this.autoScalingGroups;
    }

    public void setAutoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
        if (autoScalingGroups == null) {
            this.autoScalingGroups = null;
            return;
        }
        ArrayList<AutoScalingGroup> autoScalingGroupsCopy = new ArrayList<AutoScalingGroup>(autoScalingGroups.size());
        autoScalingGroupsCopy.addAll(autoScalingGroups);
        this.autoScalingGroups = autoScalingGroupsCopy;
    }

    public EnvironmentResourceDescription withAutoScalingGroups(AutoScalingGroup ... autoScalingGroups) {
        if (this.getAutoScalingGroups() == null) {
            this.setAutoScalingGroups(new ArrayList<AutoScalingGroup>(autoScalingGroups.length));
        }
        for (AutoScalingGroup value : autoScalingGroups) {
            this.getAutoScalingGroups().add(value);
        }
        return this;
    }

    public EnvironmentResourceDescription withAutoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
        if (autoScalingGroups == null) {
            this.autoScalingGroups = null;
        } else {
            ArrayList<AutoScalingGroup> autoScalingGroupsCopy = new ArrayList<AutoScalingGroup>(autoScalingGroups.size());
            autoScalingGroupsCopy.addAll(autoScalingGroups);
            this.autoScalingGroups = autoScalingGroupsCopy;
        }
        return this;
    }

    public List<Instance> getInstances() {
        if (this.instances == null) {
            this.instances = new ArrayList<Instance>();
        }
        return this.instances;
    }

    public void setInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        ArrayList<Instance> instancesCopy = new ArrayList<Instance>(instances.size());
        instancesCopy.addAll(instances);
        this.instances = instancesCopy;
    }

    public EnvironmentResourceDescription withInstances(Instance ... instances) {
        if (this.getInstances() == null) {
            this.setInstances(new ArrayList<Instance>(instances.length));
        }
        for (Instance value : instances) {
            this.getInstances().add(value);
        }
        return this;
    }

    public EnvironmentResourceDescription withInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
        } else {
            ArrayList<Instance> instancesCopy = new ArrayList<Instance>(instances.size());
            instancesCopy.addAll(instances);
            this.instances = instancesCopy;
        }
        return this;
    }

    public List<LaunchConfiguration> getLaunchConfigurations() {
        if (this.launchConfigurations == null) {
            this.launchConfigurations = new ArrayList<LaunchConfiguration>();
        }
        return this.launchConfigurations;
    }

    public void setLaunchConfigurations(Collection<LaunchConfiguration> launchConfigurations) {
        if (launchConfigurations == null) {
            this.launchConfigurations = null;
            return;
        }
        ArrayList<LaunchConfiguration> launchConfigurationsCopy = new ArrayList<LaunchConfiguration>(launchConfigurations.size());
        launchConfigurationsCopy.addAll(launchConfigurations);
        this.launchConfigurations = launchConfigurationsCopy;
    }

    public EnvironmentResourceDescription withLaunchConfigurations(LaunchConfiguration ... launchConfigurations) {
        if (this.getLaunchConfigurations() == null) {
            this.setLaunchConfigurations(new ArrayList<LaunchConfiguration>(launchConfigurations.length));
        }
        for (LaunchConfiguration value : launchConfigurations) {
            this.getLaunchConfigurations().add(value);
        }
        return this;
    }

    public EnvironmentResourceDescription withLaunchConfigurations(Collection<LaunchConfiguration> launchConfigurations) {
        if (launchConfigurations == null) {
            this.launchConfigurations = null;
        } else {
            ArrayList<LaunchConfiguration> launchConfigurationsCopy = new ArrayList<LaunchConfiguration>(launchConfigurations.size());
            launchConfigurationsCopy.addAll(launchConfigurations);
            this.launchConfigurations = launchConfigurationsCopy;
        }
        return this;
    }

    public List<LoadBalancer> getLoadBalancers() {
        if (this.loadBalancers == null) {
            this.loadBalancers = new ArrayList<LoadBalancer>();
        }
        return this.loadBalancers;
    }

    public void setLoadBalancers(Collection<LoadBalancer> loadBalancers) {
        if (loadBalancers == null) {
            this.loadBalancers = null;
            return;
        }
        ArrayList<LoadBalancer> loadBalancersCopy = new ArrayList<LoadBalancer>(loadBalancers.size());
        loadBalancersCopy.addAll(loadBalancers);
        this.loadBalancers = loadBalancersCopy;
    }

    public EnvironmentResourceDescription withLoadBalancers(LoadBalancer ... loadBalancers) {
        if (this.getLoadBalancers() == null) {
            this.setLoadBalancers(new ArrayList<LoadBalancer>(loadBalancers.length));
        }
        for (LoadBalancer value : loadBalancers) {
            this.getLoadBalancers().add(value);
        }
        return this;
    }

    public EnvironmentResourceDescription withLoadBalancers(Collection<LoadBalancer> loadBalancers) {
        if (loadBalancers == null) {
            this.loadBalancers = null;
        } else {
            ArrayList<LoadBalancer> loadBalancersCopy = new ArrayList<LoadBalancer>(loadBalancers.size());
            loadBalancersCopy.addAll(loadBalancers);
            this.loadBalancers = loadBalancersCopy;
        }
        return this;
    }

    public List<Trigger> getTriggers() {
        if (this.triggers == null) {
            this.triggers = new ArrayList<Trigger>();
        }
        return this.triggers;
    }

    public void setTriggers(Collection<Trigger> triggers) {
        if (triggers == null) {
            this.triggers = null;
            return;
        }
        ArrayList<Trigger> triggersCopy = new ArrayList<Trigger>(triggers.size());
        triggersCopy.addAll(triggers);
        this.triggers = triggersCopy;
    }

    public EnvironmentResourceDescription withTriggers(Trigger ... triggers) {
        if (this.getTriggers() == null) {
            this.setTriggers(new ArrayList<Trigger>(triggers.length));
        }
        for (Trigger value : triggers) {
            this.getTriggers().add(value);
        }
        return this;
    }

    public EnvironmentResourceDescription withTriggers(Collection<Trigger> triggers) {
        if (triggers == null) {
            this.triggers = null;
        } else {
            ArrayList<Trigger> triggersCopy = new ArrayList<Trigger>(triggers.size());
            triggersCopy.addAll(triggers);
            this.triggers = triggersCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.environmentName != null) {
            sb.append("EnvironmentName: " + this.environmentName + ", ");
        }
        if (this.autoScalingGroups != null) {
            sb.append("AutoScalingGroups: " + this.autoScalingGroups + ", ");
        }
        if (this.instances != null) {
            sb.append("Instances: " + this.instances + ", ");
        }
        if (this.launchConfigurations != null) {
            sb.append("LaunchConfigurations: " + this.launchConfigurations + ", ");
        }
        if (this.loadBalancers != null) {
            sb.append("LoadBalancers: " + this.loadBalancers + ", ");
        }
        if (this.triggers != null) {
            sb.append("Triggers: " + this.triggers + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEnvironmentName() == null ? 0 : this.getEnvironmentName().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingGroups() == null ? 0 : ((Object)this.getAutoScalingGroups()).hashCode());
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : ((Object)this.getInstances()).hashCode());
        hashCode = 31 * hashCode + (this.getLaunchConfigurations() == null ? 0 : ((Object)this.getLaunchConfigurations()).hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancers() == null ? 0 : ((Object)this.getLoadBalancers()).hashCode());
        hashCode = 31 * hashCode + (this.getTriggers() == null ? 0 : ((Object)this.getTriggers()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentResourceDescription)) {
            return false;
        }
        EnvironmentResourceDescription other = (EnvironmentResourceDescription)obj;
        if (other.getEnvironmentName() == null ^ this.getEnvironmentName() == null) {
            return false;
        }
        if (other.getEnvironmentName() != null && !other.getEnvironmentName().equals(this.getEnvironmentName())) {
            return false;
        }
        if (other.getAutoScalingGroups() == null ^ this.getAutoScalingGroups() == null) {
            return false;
        }
        if (other.getAutoScalingGroups() != null && !((Object)other.getAutoScalingGroups()).equals(this.getAutoScalingGroups())) {
            return false;
        }
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !((Object)other.getInstances()).equals(this.getInstances())) {
            return false;
        }
        if (other.getLaunchConfigurations() == null ^ this.getLaunchConfigurations() == null) {
            return false;
        }
        if (other.getLaunchConfigurations() != null && !((Object)other.getLaunchConfigurations()).equals(this.getLaunchConfigurations())) {
            return false;
        }
        if (other.getLoadBalancers() == null ^ this.getLoadBalancers() == null) {
            return false;
        }
        if (other.getLoadBalancers() != null && !((Object)other.getLoadBalancers()).equals(this.getLoadBalancers())) {
            return false;
        }
        if (other.getTriggers() == null ^ this.getTriggers() == null) {
            return false;
        }
        return other.getTriggers() == null || ((Object)other.getTriggers()).equals(this.getTriggers());
    }
}

