/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.services.elasticache.model.CacheNode;
import com.amazonaws.services.elasticache.model.transform.EndpointStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheNodeStaxUnmarshaller
implements Unmarshaller<CacheNode, StaxUnmarshallerContext> {
    private static CacheNodeStaxUnmarshaller instance;

    @Override
    public CacheNode unmarshall(StaxUnmarshallerContext context) throws Exception {
        CacheNode cacheNode = new CacheNode();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return cacheNode;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CacheNodeId", targetDepth)) {
                    cacheNode.setCacheNodeId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheNodeStatus", targetDepth)) {
                    cacheNode.setCacheNodeStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheNodeCreateTime", targetDepth)) {
                    cacheNode.setCacheNodeCreateTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Endpoint", targetDepth)) {
                    cacheNode.setEndpoint(EndpointStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ParameterGroupStatus", targetDepth)) continue;
                cacheNode.setParameterGroupStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return cacheNode;
    }

    public static CacheNodeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CacheNodeStaxUnmarshaller();
        }
        return instance;
    }
}

