/*
 * Decompiled with CFR 0.152.
 */
package nbl.utilj;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import nbl.utilj.TableModelRowable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditableTableModel
extends AbstractTableModel {
    List<TableModelRowable> rows;

    public EditableTableModel(List<TableModelRowable> rows) {
        if (rows.size() < 1) {
            throw new RuntimeException("EditableTableModel() was passed an empty row list.");
        }
        this.rows = rows;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.rows.get(0).getNColumns();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.rows.get(rowIndex).getColumnValue(columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        return this.rows.get(0).getColumnName(column);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TableModelRowable r = this.rows.get(row);
        r.setColumnValue(col, value);
        this.fireTableCellUpdated(row, col);
    }

    public void addRow(TableModelRowable r) {
        this.rows.add(r);
        this.fireTableDataChanged();
    }

    public List<TableModelRowable> getRows() {
        return this.rows;
    }
}

