/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleworkflow.model.ExecutionTimeFilter;
import com.amazonaws.services.simpleworkflow.model.ListOpenWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.TagFilter;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionFilter;
import com.amazonaws.services.simpleworkflow.model.WorkflowTypeFilter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListOpenWorkflowExecutionsRequestMarshaller
implements Marshaller<Request<ListOpenWorkflowExecutionsRequest>, ListOpenWorkflowExecutionsRequest> {
    @Override
    public Request<ListOpenWorkflowExecutionsRequest> marshall(ListOpenWorkflowExecutionsRequest listOpenWorkflowExecutionsRequest) {
        if (listOpenWorkflowExecutionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListOpenWorkflowExecutionsRequest> request = new DefaultRequest<ListOpenWorkflowExecutionsRequest>(listOpenWorkflowExecutionsRequest, "AmazonSimpleWorkflow");
        String target = "SimpleWorkflowService.ListOpenWorkflowExecutions";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        try {
            WorkflowExecutionFilter workflowExecutionFilterExecutionFilter;
            TagFilter tagFilterTagFilter;
            WorkflowTypeFilter workflowTypeFilterTypeFilter;
            ExecutionTimeFilter executionTimeFilterStartTimeFilter;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listOpenWorkflowExecutionsRequest.getDomain() != null) {
                jsonWriter.key("domain").value(listOpenWorkflowExecutionsRequest.getDomain());
            }
            if (listOpenWorkflowExecutionsRequest != null && (executionTimeFilterStartTimeFilter = listOpenWorkflowExecutionsRequest.getStartTimeFilter()) != null) {
                jsonWriter.key("startTimeFilter").object();
                if (executionTimeFilterStartTimeFilter.getOldestDate() != null) {
                    jsonWriter.key("oldestDate").value(executionTimeFilterStartTimeFilter.getOldestDate());
                }
                if (executionTimeFilterStartTimeFilter.getLatestDate() != null) {
                    jsonWriter.key("latestDate").value(executionTimeFilterStartTimeFilter.getLatestDate());
                }
                jsonWriter.endObject();
            }
            if (listOpenWorkflowExecutionsRequest != null && (workflowTypeFilterTypeFilter = listOpenWorkflowExecutionsRequest.getTypeFilter()) != null) {
                jsonWriter.key("typeFilter").object();
                if (workflowTypeFilterTypeFilter.getName() != null) {
                    jsonWriter.key("name").value(workflowTypeFilterTypeFilter.getName());
                }
                if (workflowTypeFilterTypeFilter.getVersion() != null) {
                    jsonWriter.key("version").value(workflowTypeFilterTypeFilter.getVersion());
                }
                jsonWriter.endObject();
            }
            if (listOpenWorkflowExecutionsRequest != null && (tagFilterTagFilter = listOpenWorkflowExecutionsRequest.getTagFilter()) != null) {
                jsonWriter.key("tagFilter").object();
                if (tagFilterTagFilter.getTag() != null) {
                    jsonWriter.key("tag").value(tagFilterTagFilter.getTag());
                }
                jsonWriter.endObject();
            }
            if (listOpenWorkflowExecutionsRequest.getNextPageToken() != null) {
                jsonWriter.key("nextPageToken").value(listOpenWorkflowExecutionsRequest.getNextPageToken());
            }
            if (listOpenWorkflowExecutionsRequest.getMaximumPageSize() != null) {
                jsonWriter.key("maximumPageSize").value(listOpenWorkflowExecutionsRequest.getMaximumPageSize());
            }
            if (listOpenWorkflowExecutionsRequest.isReverseOrder() != null) {
                jsonWriter.key("reverseOrder").value(listOpenWorkflowExecutionsRequest.isReverseOrder());
            }
            if (listOpenWorkflowExecutionsRequest != null && (workflowExecutionFilterExecutionFilter = listOpenWorkflowExecutionsRequest.getExecutionFilter()) != null) {
                jsonWriter.key("executionFilter").object();
                if (workflowExecutionFilterExecutionFilter.getWorkflowId() != null) {
                    jsonWriter.key("workflowId").value(workflowExecutionFilterExecutionFilter.getWorkflowId());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            return request;
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

