/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS3Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.model.ActivityTask;
import com.amazonaws.services.simpleworkflow.model.ActivityTaskStatus;
import com.amazonaws.services.simpleworkflow.model.ActivityTypeDetail;
import com.amazonaws.services.simpleworkflow.model.ActivityTypeInfos;
import com.amazonaws.services.simpleworkflow.model.CountClosedWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.CountOpenWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.CountPendingActivityTasksRequest;
import com.amazonaws.services.simpleworkflow.model.CountPendingDecisionTasksRequest;
import com.amazonaws.services.simpleworkflow.model.DecisionTask;
import com.amazonaws.services.simpleworkflow.model.DeprecateActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DeprecateDomainRequest;
import com.amazonaws.services.simpleworkflow.model.DeprecateWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeDomainRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.DescribeWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.DomainDetail;
import com.amazonaws.services.simpleworkflow.model.DomainInfos;
import com.amazonaws.services.simpleworkflow.model.GetWorkflowExecutionHistoryRequest;
import com.amazonaws.services.simpleworkflow.model.History;
import com.amazonaws.services.simpleworkflow.model.ListActivityTypesRequest;
import com.amazonaws.services.simpleworkflow.model.ListClosedWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.ListDomainsRequest;
import com.amazonaws.services.simpleworkflow.model.ListOpenWorkflowExecutionsRequest;
import com.amazonaws.services.simpleworkflow.model.ListWorkflowTypesRequest;
import com.amazonaws.services.simpleworkflow.model.PendingTaskCount;
import com.amazonaws.services.simpleworkflow.model.PollForActivityTaskRequest;
import com.amazonaws.services.simpleworkflow.model.PollForDecisionTaskRequest;
import com.amazonaws.services.simpleworkflow.model.RecordActivityTaskHeartbeatRequest;
import com.amazonaws.services.simpleworkflow.model.RegisterActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.RegisterDomainRequest;
import com.amazonaws.services.simpleworkflow.model.RegisterWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.RequestCancelWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskCanceledRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskCompletedRequest;
import com.amazonaws.services.simpleworkflow.model.RespondActivityTaskFailedRequest;
import com.amazonaws.services.simpleworkflow.model.RespondDecisionTaskCompletedRequest;
import com.amazonaws.services.simpleworkflow.model.Run;
import com.amazonaws.services.simpleworkflow.model.SignalWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.StartWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.TerminateWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionCount;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionDetail;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionInfos;
import com.amazonaws.services.simpleworkflow.model.WorkflowTypeDetail;
import com.amazonaws.services.simpleworkflow.model.WorkflowTypeInfos;
import com.amazonaws.services.simpleworkflow.model.transform.ActivityTaskJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ActivityTaskStatusJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ActivityTypeDetailJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ActivityTypeInfosJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.CountClosedWorkflowExecutionsRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.CountOpenWorkflowExecutionsRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.CountPendingActivityTasksRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.CountPendingDecisionTasksRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DecisionTaskJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DefaultUndefinedExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DeprecateActivityTypeRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DeprecateDomainRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DeprecateWorkflowTypeRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DescribeActivityTypeRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DescribeDomainRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DescribeWorkflowExecutionRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DescribeWorkflowTypeRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DomainAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DomainDeprecatedExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DomainDetailJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.DomainInfosJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.GetWorkflowExecutionHistoryRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.HistoryJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ListActivityTypesRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ListClosedWorkflowExecutionsRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ListDomainsRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ListOpenWorkflowExecutionsRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.ListWorkflowTypesRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.OperationNotPermittedExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.PendingTaskCountJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.PollForActivityTaskRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.PollForDecisionTaskRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RecordActivityTaskHeartbeatRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RegisterActivityTypeRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RegisterDomainRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RegisterWorkflowTypeRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RequestCancelWorkflowExecutionRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RespondActivityTaskCanceledRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RespondActivityTaskCompletedRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RespondActivityTaskFailedRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RespondDecisionTaskCompletedRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.RunJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.SignalWorkflowExecutionRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.StartWorkflowExecutionRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.TerminateWorkflowExecutionRequestMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.TypeAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.TypeDeprecatedExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.UnknownResourceExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowExecutionAlreadyStartedExceptionUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowExecutionCountJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowExecutionDetailJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowExecutionInfosJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowTypeDetailJsonUnmarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowTypeInfosJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonSimpleWorkflowClient
extends AmazonWebServiceClient
implements AmazonSimpleWorkflow {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonSimpleWorkflow.class);
    protected List<Unmarshaller<AmazonServiceException, JSONObject>> exceptionUnmarshallers;
    private AWS3Signer signer;

    public AmazonSimpleWorkflowClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonSimpleWorkflowClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonSimpleWorkflowClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonSimpleWorkflowClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, JSONObject>>();
        this.exceptionUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DomainAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DomainDeprecatedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DefaultUndefinedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new OperationNotPermittedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new UnknownResourceExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new WorkflowExecutionAlreadyStartedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TypeDeprecatedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TypeAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("swf.amazonaws.com");
        this.signer = new AWS3Signer();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/simpleworkflow/request.handlers"));
        this.clientConfiguration = new ClientConfiguration(this.clientConfiguration);
        if (this.clientConfiguration.getMaxConnections() == 50) {
            log.debug((Object)"Overriding default max connection value to: 1000");
            this.clientConfiguration.setMaxConnections(1000);
        }
        if (this.clientConfiguration.getSocketTimeout() == 50000) {
            log.debug((Object)"Overriding default socket timeout value to: 90000");
            this.clientConfiguration.setSocketTimeout(90000);
        }
        this.setConfiguration(this.clientConfiguration);
    }

    @Override
    public void deprecateWorkflowType(DeprecateWorkflowTypeRequest deprecateWorkflowTypeRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeprecateWorkflowTypeRequest> request = new DeprecateWorkflowTypeRequestMarshaller().marshall(deprecateWorkflowTypeRequest);
        this.invoke(request, null);
    }

    @Override
    public void deprecateDomain(DeprecateDomainRequest deprecateDomainRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeprecateDomainRequest> request = new DeprecateDomainRequestMarshaller().marshall(deprecateDomainRequest);
        this.invoke(request, null);
    }

    @Override
    public void registerWorkflowType(RegisterWorkflowTypeRequest registerWorkflowTypeRequest) throws AmazonServiceException, AmazonClientException {
        Request<RegisterWorkflowTypeRequest> request = new RegisterWorkflowTypeRequestMarshaller().marshall(registerWorkflowTypeRequest);
        this.invoke(request, null);
    }

    @Override
    public WorkflowTypeInfos listWorkflowTypes(ListWorkflowTypesRequest listWorkflowTypesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListWorkflowTypesRequest> request = new ListWorkflowTypesRequestMarshaller().marshall(listWorkflowTypesRequest);
        return this.invoke(request, new WorkflowTypeInfosJsonUnmarshaller());
    }

    @Override
    public Run startWorkflowExecution(StartWorkflowExecutionRequest startWorkflowExecutionRequest) throws AmazonServiceException, AmazonClientException {
        Request<StartWorkflowExecutionRequest> request = new StartWorkflowExecutionRequestMarshaller().marshall(startWorkflowExecutionRequest);
        return this.invoke(request, new RunJsonUnmarshaller());
    }

    @Override
    public void signalWorkflowExecution(SignalWorkflowExecutionRequest signalWorkflowExecutionRequest) throws AmazonServiceException, AmazonClientException {
        Request<SignalWorkflowExecutionRequest> request = new SignalWorkflowExecutionRequestMarshaller().marshall(signalWorkflowExecutionRequest);
        this.invoke(request, null);
    }

    @Override
    public DomainInfos listDomains(ListDomainsRequest listDomainsRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListDomainsRequest> request = new ListDomainsRequestMarshaller().marshall(listDomainsRequest);
        return this.invoke(request, new DomainInfosJsonUnmarshaller());
    }

    @Override
    public void requestCancelWorkflowExecution(RequestCancelWorkflowExecutionRequest requestCancelWorkflowExecutionRequest) throws AmazonServiceException, AmazonClientException {
        Request<RequestCancelWorkflowExecutionRequest> request = new RequestCancelWorkflowExecutionRequestMarshaller().marshall(requestCancelWorkflowExecutionRequest);
        this.invoke(request, null);
    }

    @Override
    public WorkflowTypeDetail describeWorkflowType(DescribeWorkflowTypeRequest describeWorkflowTypeRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeWorkflowTypeRequest> request = new DescribeWorkflowTypeRequestMarshaller().marshall(describeWorkflowTypeRequest);
        return this.invoke(request, new WorkflowTypeDetailJsonUnmarshaller());
    }

    @Override
    public void deprecateActivityType(DeprecateActivityTypeRequest deprecateActivityTypeRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeprecateActivityTypeRequest> request = new DeprecateActivityTypeRequestMarshaller().marshall(deprecateActivityTypeRequest);
        this.invoke(request, null);
    }

    @Override
    public WorkflowExecutionCount countClosedWorkflowExecutions(CountClosedWorkflowExecutionsRequest countClosedWorkflowExecutionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<CountClosedWorkflowExecutionsRequest> request = new CountClosedWorkflowExecutionsRequestMarshaller().marshall(countClosedWorkflowExecutionsRequest);
        return this.invoke(request, new WorkflowExecutionCountJsonUnmarshaller());
    }

    @Override
    public PendingTaskCount countPendingActivityTasks(CountPendingActivityTasksRequest countPendingActivityTasksRequest) throws AmazonServiceException, AmazonClientException {
        Request<CountPendingActivityTasksRequest> request = new CountPendingActivityTasksRequestMarshaller().marshall(countPendingActivityTasksRequest);
        return this.invoke(request, new PendingTaskCountJsonUnmarshaller());
    }

    @Override
    public void respondActivityTaskCanceled(RespondActivityTaskCanceledRequest respondActivityTaskCanceledRequest) throws AmazonServiceException, AmazonClientException {
        Request<RespondActivityTaskCanceledRequest> request = new RespondActivityTaskCanceledRequestMarshaller().marshall(respondActivityTaskCanceledRequest);
        this.invoke(request, null);
    }

    @Override
    public void respondDecisionTaskCompleted(RespondDecisionTaskCompletedRequest respondDecisionTaskCompletedRequest) throws AmazonServiceException, AmazonClientException {
        Request<RespondDecisionTaskCompletedRequest> request = new RespondDecisionTaskCompletedRequestMarshaller().marshall(respondDecisionTaskCompletedRequest);
        this.invoke(request, null);
    }

    @Override
    public void respondActivityTaskCompleted(RespondActivityTaskCompletedRequest respondActivityTaskCompletedRequest) throws AmazonServiceException, AmazonClientException {
        Request<RespondActivityTaskCompletedRequest> request = new RespondActivityTaskCompletedRequestMarshaller().marshall(respondActivityTaskCompletedRequest);
        this.invoke(request, null);
    }

    @Override
    public ActivityTask pollForActivityTask(PollForActivityTaskRequest pollForActivityTaskRequest) throws AmazonServiceException, AmazonClientException {
        Request<PollForActivityTaskRequest> request = new PollForActivityTaskRequestMarshaller().marshall(pollForActivityTaskRequest);
        return this.invoke(request, new ActivityTaskJsonUnmarshaller());
    }

    @Override
    public WorkflowExecutionCount countOpenWorkflowExecutions(CountOpenWorkflowExecutionsRequest countOpenWorkflowExecutionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<CountOpenWorkflowExecutionsRequest> request = new CountOpenWorkflowExecutionsRequestMarshaller().marshall(countOpenWorkflowExecutionsRequest);
        return this.invoke(request, new WorkflowExecutionCountJsonUnmarshaller());
    }

    @Override
    public ActivityTypeDetail describeActivityType(DescribeActivityTypeRequest describeActivityTypeRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeActivityTypeRequest> request = new DescribeActivityTypeRequestMarshaller().marshall(describeActivityTypeRequest);
        return this.invoke(request, new ActivityTypeDetailJsonUnmarshaller());
    }

    @Override
    public WorkflowExecutionInfos listOpenWorkflowExecutions(ListOpenWorkflowExecutionsRequest listOpenWorkflowExecutionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListOpenWorkflowExecutionsRequest> request = new ListOpenWorkflowExecutionsRequestMarshaller().marshall(listOpenWorkflowExecutionsRequest);
        return this.invoke(request, new WorkflowExecutionInfosJsonUnmarshaller());
    }

    @Override
    public History getWorkflowExecutionHistory(GetWorkflowExecutionHistoryRequest getWorkflowExecutionHistoryRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetWorkflowExecutionHistoryRequest> request = new GetWorkflowExecutionHistoryRequestMarshaller().marshall(getWorkflowExecutionHistoryRequest);
        return this.invoke(request, new HistoryJsonUnmarshaller());
    }

    @Override
    public void registerDomain(RegisterDomainRequest registerDomainRequest) throws AmazonServiceException, AmazonClientException {
        Request<RegisterDomainRequest> request = new RegisterDomainRequestMarshaller().marshall(registerDomainRequest);
        this.invoke(request, null);
    }

    @Override
    public void registerActivityType(RegisterActivityTypeRequest registerActivityTypeRequest) throws AmazonServiceException, AmazonClientException {
        Request<RegisterActivityTypeRequest> request = new RegisterActivityTypeRequestMarshaller().marshall(registerActivityTypeRequest);
        this.invoke(request, null);
    }

    @Override
    public WorkflowExecutionInfos listClosedWorkflowExecutions(ListClosedWorkflowExecutionsRequest listClosedWorkflowExecutionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListClosedWorkflowExecutionsRequest> request = new ListClosedWorkflowExecutionsRequestMarshaller().marshall(listClosedWorkflowExecutionsRequest);
        return this.invoke(request, new WorkflowExecutionInfosJsonUnmarshaller());
    }

    @Override
    public ActivityTaskStatus recordActivityTaskHeartbeat(RecordActivityTaskHeartbeatRequest recordActivityTaskHeartbeatRequest) throws AmazonServiceException, AmazonClientException {
        Request<RecordActivityTaskHeartbeatRequest> request = new RecordActivityTaskHeartbeatRequestMarshaller().marshall(recordActivityTaskHeartbeatRequest);
        return this.invoke(request, new ActivityTaskStatusJsonUnmarshaller());
    }

    @Override
    public DecisionTask pollForDecisionTask(PollForDecisionTaskRequest pollForDecisionTaskRequest) throws AmazonServiceException, AmazonClientException {
        Request<PollForDecisionTaskRequest> request = new PollForDecisionTaskRequestMarshaller().marshall(pollForDecisionTaskRequest);
        return this.invoke(request, new DecisionTaskJsonUnmarshaller());
    }

    @Override
    public ActivityTypeInfos listActivityTypes(ListActivityTypesRequest listActivityTypesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListActivityTypesRequest> request = new ListActivityTypesRequestMarshaller().marshall(listActivityTypesRequest);
        return this.invoke(request, new ActivityTypeInfosJsonUnmarshaller());
    }

    @Override
    public DomainDetail describeDomain(DescribeDomainRequest describeDomainRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeDomainRequest> request = new DescribeDomainRequestMarshaller().marshall(describeDomainRequest);
        return this.invoke(request, new DomainDetailJsonUnmarshaller());
    }

    @Override
    public void respondActivityTaskFailed(RespondActivityTaskFailedRequest respondActivityTaskFailedRequest) throws AmazonServiceException, AmazonClientException {
        Request<RespondActivityTaskFailedRequest> request = new RespondActivityTaskFailedRequestMarshaller().marshall(respondActivityTaskFailedRequest);
        this.invoke(request, null);
    }

    @Override
    public PendingTaskCount countPendingDecisionTasks(CountPendingDecisionTasksRequest countPendingDecisionTasksRequest) throws AmazonServiceException, AmazonClientException {
        Request<CountPendingDecisionTasksRequest> request = new CountPendingDecisionTasksRequestMarshaller().marshall(countPendingDecisionTasksRequest);
        return this.invoke(request, new PendingTaskCountJsonUnmarshaller());
    }

    @Override
    public void terminateWorkflowExecution(TerminateWorkflowExecutionRequest terminateWorkflowExecutionRequest) throws AmazonServiceException, AmazonClientException {
        Request<TerminateWorkflowExecutionRequest> request = new TerminateWorkflowExecutionRequestMarshaller().marshall(terminateWorkflowExecutionRequest);
        this.invoke(request, null);
    }

    @Override
    public WorkflowExecutionDetail describeWorkflowExecution(DescribeWorkflowExecutionRequest describeWorkflowExecutionRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeWorkflowExecutionRequest> request = new DescribeWorkflowExecutionRequestMarshaller().marshall(describeWorkflowExecutionRequest);
        return this.invoke(request, new WorkflowExecutionDetailJsonUnmarshaller());
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, JsonUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        ExecutionContext executionContext = this.createExecutionContext();
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        JsonResponseHandler<X> responseHandler = new JsonResponseHandler<X>(unmarshaller);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

