/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.util.aws;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.norbl.cbp.ppe.ParamsEc2;
import com.norbl.util.MissingParamsException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.io.StreamCorruptedException;

public class S3Access {
    ParamsEc2 paramsEc2;
    AmazonS3Client s3Client;

    public S3Access(ParamsEc2 paramsEc2) throws MissingParamsException {
        this.paramsEc2 = paramsEc2;
        this.s3Client = new AmazonS3Client(paramsEc2.buildAWSCredentials());
    }

    public S3Access(AmazonS3Client s3Client) {
        this.s3Client = s3Client;
    }

    public S3Access() {
        this.s3Client = new AmazonS3Client();
    }

    public void close() {
        this.s3Client.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void putObject(String bucketName, String key, Serializable obj, boolean publicReadable) {
        ByteArrayInputStream bis = null;
        try {
            byte[] b = S3Access.objectToByteArray(obj);
            bis = new ByteArrayInputStream(b);
            ObjectMetadata omd = new ObjectMetadata();
            omd.setContentType("application/octet-stream");
            omd.setContentLength((long)b.length);
            PutObjectRequest r = new PutObjectRequest(bucketName, key, (InputStream)bis, omd);
            this.s3Client.putObject(r);
            if (publicReadable) {
                this.s3Client.setObjectAcl(bucketName, key, CannedAccessControlList.PublicRead);
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception xxx) {
                System.err.println(xxx);
            }
        }
    }

    public synchronized Object getObject(String bucketName, String key) {
        try {
            GetObjectRequest r = new GetObjectRequest(bucketName, key);
            S3Object s3o = this.s3Client.getObject(r);
            S3ObjectInputStream sois = s3o.getObjectContent();
            ObjectInputStream ois = new ObjectInputStream((InputStream)sois);
            return ois.readObject();
        }
        catch (AmazonServiceException asx) {
            return null;
        }
        catch (IOException iox) {
            System.err.println(iox);
            return null;
        }
        catch (ClassNotFoundException cx) {
            System.err.println(cx);
            return null;
        }
    }

    private static byte[] objectToByteArray(Object obj) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.reset();
            byte[] b = baos.toByteArray();
            baos = null;
            return b;
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
    }

    private static Object byteArrayToObject(byte[] B) {
        try {
            ByteArrayInputStream baos = new ByteArrayInputStream(B, 0, B.length);
            Object obj = new Object();
            ObjectInputStreamWithPrimitiveSupport oos = new ObjectInputStreamWithPrimitiveSupport(baos);
            obj = oos.readObject();
            oos.close();
            baos = null;
            return obj;
        }
        catch (InvalidClassException xc) {
            throw new RuntimeException(xc);
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
        catch (ClassNotFoundException cnfx) {
            throw new RuntimeException(cnfx);
        }
    }

    private static class ObjectInputStreamWithPrimitiveSupport
    extends ObjectInputStream {
        public ObjectInputStreamWithPrimitiveSupport(InputStream is) throws IOException, StreamCorruptedException {
            super(is);
        }

        public Class resolveClass(ObjectStreamClass desc) throws ClassNotFoundException, IOException {
            try {
                return super.resolveClass(desc);
            }
            catch (ClassNotFoundException e) {
                String nm = desc.getName();
                if (nm.equals("int")) {
                    return Integer.TYPE;
                }
                if (nm.equals("long")) {
                    return Long.TYPE;
                }
                if (nm.equals("float")) {
                    return Float.TYPE;
                }
                if (nm.equals("double")) {
                    return Double.TYPE;
                }
                if (nm.equals("char")) {
                    return Character.TYPE;
                }
                if (nm.equals("boolean")) {
                    return Boolean.TYPE;
                }
                if (nm.equals("short")) {
                    return Short.TYPE;
                }
                if (nm.equals("byte")) {
                    return Byte.TYPE;
                }
                throw e;
            }
        }
    }
}

