/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.ompi;

import com.amazonaws.services.ec2.model.InstanceType;
import com.norbl.cbp.ppe.ParamsEc2;
import com.norbl.util.ImproperParamException;
import com.norbl.util.InaccessibleFileException;
import com.norbl.util.MissingParamsException;
import com.norbl.util.ParamHt;
import java.io.File;

public class ParamsOmpi {
    public String networkName;
    public File rsaKeyPairFile;
    public int slotsPerHost;
    public boolean disableHyperthreading;
    public InstanceType instanceType;
    ParamHt ht;

    public ParamsOmpi(ParamHt ht, ParamsEc2 paramsEc2) throws InaccessibleFileException, ImproperParamException, MissingParamsException {
        this.ht = ht;
        this.setParamVals();
        this.networkName = paramsEc2.networkName;
        this.disableHyperthreading = paramsEc2.disableHyperthreading;
        this.instanceType = paramsEc2.instanceType;
        this.checkForAccessInstanceParams();
    }

    public void setParamVals() throws InaccessibleFileException, ImproperParamException {
        for (String key : this.ht.keySet()) {
            String val = (String)this.ht.get(key);
            this.setParamVal(key, val);
        }
    }

    public void setParamVal(String key, String val) throws InaccessibleFileException, ImproperParamException {
        String value = val.trim();
        try {
            ParamName nm = ParamName.valueOf(key);
            switch (nm) {
                case rsaKeyPairFile: {
                    this.rsaKeyPairFile = new File(value);
                    this.checkForReadFileAccess(this.rsaKeyPairFile);
                    break;
                }
                case slotsPerHost: {
                    this.slotsPerHost = Integer.parseInt(value);
                    break;
                }
            }
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
    }

    private void checkForReadFileAccess(File f) throws InaccessibleFileException {
        if (f.exists() && !f.isDirectory() && f.canRead()) {
            return;
        }
        throw new InaccessibleFileException("RSA key pair file " + f.getPath() + " is not accessible: exists=" + f.exists() + "  is file=" + !f.isDirectory() + "  can read=" + f.canRead());
    }

    public void checkForAccessInstanceParams() throws MissingParamsException {
        String cfs = this.getConfigFileSuffix();
        String s = "";
        if (this.rsaKeyPairFile == null) {
            if (s.length() > 0) {
                s = s + "rsaKeyPairFile ";
            }
            s = s + "The required param rsaKeyPairFile was not specified in argv " + cfs;
            throw new MissingParamsException(s);
        }
    }

    private String getConfigFileSuffix() {
        String configFile = (String)this.ht.get(ParamHt.ParamName.configFile.toString());
        String cfs = configFile != null ? "or in config file " + configFile : "and the default config file " + ParamHt.getDefaultConfigFilePath(this.ht.configFilenameDefault) + " does not exist.";
        return cfs;
    }

    public static enum ParamName {
        networkName,
        rsaKeyPairFile,
        slotsPerHost,
        disableHyperthreading,
        instanceType;

    }
}

