/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe;

import com.norbl.cbp.ppe.EbsVolumeWrangler;
import com.norbl.cbp.ppe.InstanceTableModel;
import com.norbl.cbp.ppe.NetworkInfo;
import com.norbl.cbp.ppe.NiM;
import com.norbl.cbp.ppe.StateChangeListener;
import com.norbl.cbp.ppe.gui.InstanceTablePopup;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;

public class InstanceTableManager
implements StateChangeListener {
    HashMap<String, Itm> ht;
    JTabbedPane tabbedPane;
    EbsVolumeWrangler ebsVolumeWrangler;

    public InstanceTableManager(EbsVolumeWrangler ebsVolumeWrangler) {
        this.ebsVolumeWrangler = ebsVolumeWrangler;
        this.ht = new HashMap();
    }

    public void setTabbedPane(JTabbedPane tabbedPane) {
        this.tabbedPane = tabbedPane;
    }

    @Override
    public void stateChanged() {
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        List<NetworkInfo> nis;
        long updateTime = System.currentTimeMillis();
        List<NetworkInfo> list = nis = NiM.getNetworks();
        synchronized (list) {
            for (NetworkInfo ni : nis) {
                Itm itm = this.ht.get(ni.getNetworkID());
                if (itm == null && this.tabbedPane != null) {
                    itm = new Itm(ni);
                    this.ht.put(itm.ni.getNetworkID(), itm);
                    itm.createJComponents(this.tabbedPane);
                }
                if (itm == null) continue;
                itm.tableModel.stateChanged();
                itm.updateTime = updateTime;
            }
        }
        ArrayList<String> deceasedNetworks = new ArrayList<String>();
        for (Itm itm : this.ht.values()) {
            if (itm.updateTime >= updateTime) continue;
            deceasedNetworks.add(itm.ni.getNetworkID());
        }
        for (String nid : deceasedNetworks) {
            Itm x = this.ht.remove(nid);
            if (this.tabbedPane == null || x.scrollPane == null) continue;
            x.removeFromTabbedPane(this.tabbedPane);
        }
    }

    public void setEbsVolumeWrangler(EbsVolumeWrangler ebsVolumeWrangler) {
        this.ebsVolumeWrangler = ebsVolumeWrangler;
    }

    class Itm {
        NetworkInfo ni;
        InstanceTableModel tableModel;
        JScrollPane scrollPane;
        long updateTime = 0L;
        InstanceTablePopup itPopup;

        Itm(NetworkInfo ni) {
            this.ni = ni;
            this.tableModel = new InstanceTableModel(ni);
            NiM.addStateChangeListener(this.tableModel);
        }

        void createJComponents(final JTabbedPane tabbedPane) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Itm.this.scrollPane = new JScrollPane();
                    JTable jt = new JTable();
                    jt.setModel(Itm.this.tableModel);
                    jt.setCellSelectionEnabled(true);
                    Itm.this.scrollPane.setViewportView(jt);
                    tabbedPane.addTab(Itm.this.ni.getNetworkName(), Itm.this.scrollPane);
                    if (InstanceTableManager.this.ebsVolumeWrangler != null) {
                        Itm.this.itPopup = new InstanceTablePopup(jt, Itm.this.tableModel, InstanceTableManager.this.ebsVolumeWrangler);
                    }
                }
            });
        }

        void removeFromTabbedPane(final JTabbedPane tabbedPane) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    tabbedPane.remove(Itm.this.scrollPane);
                    Itm.this.scrollPane = null;
                }
            });
        }
    }
}

