/*
 * Decompiled with CFR 0.152.
 */
package nbl.utilj;

public class StringUtil {
    public static String toString(Throwable x) {
        return StringUtil.exceptionStackToString(x) + "\n\n" + StringUtil.getExceptionMessage(x);
    }

    public static String getExceptionMessage(Throwable x) {
        Throwable c = x.getCause();
        if (c != null && c.getMessage() != null && c.getMessage().length() > 0) {
            return c.getMessage();
        }
        return x.toString();
    }

    public static String exceptionStackToString(Throwable x) {
        if (x == null) {
            return "NULL exception!";
        }
        return StringUtil.throwableToString(x, "");
    }

    private static String throwableToString(Throwable x, String prefix) {
        String mess = x.toString() + "\n\n" + StringUtil.stackTraceToString(x.getStackTrace());
        Throwable cause = x.getCause();
        if (cause != null) {
            mess = mess + "\nCAUSE:\n" + StringUtil.throwableToString(cause, prefix + "    ");
        }
        return mess;
    }

    public static String stackTraceToString(StackTraceElement[] trace) {
        if (trace == null) {
            return "NULL stack trace.";
        }
        String s = "";
        for (int i = 0; i < trace.length; ++i) {
            s = trace[i] != null ? s + trace[i].toString() + "\n" : s + "null trace element at [" + i + "]";
        }
        return s;
    }

    public static String wordsToString(String[] words) {
        if (words.length < 1) {
            return "";
        }
        String s = words[0];
        for (int i = 1; i < words.length; ++i) {
            s = s + " " + words[i];
        }
        return s;
    }
}

