/*
 * Decompiled with CFR 0.152.
 */
package ppe.gui;

import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import ppe.ExceptionHandler;
import ppe.ec2.NetworkInfo;
import ppe.ec2.NiM;
import ppe.gui.ActionCommand;
import ppe.gui.NetworkTableModel;
import ppe.gui.PPEManager;

public class NetworkTablePopup {
    PPEManager ppeManager;
    JTable table;
    NetworkTableModel model;
    int networkNameCol;
    ClickHandler clickHandler;
    NetworkInfo ni;
    List<MiSpec> miSpecs;

    public NetworkTablePopup(PPEManager ppeManager, JTable table) {
        this.table = table;
        this.ppeManager = ppeManager;
        this.model = (NetworkTableModel)table.getModel();
        this.networkNameCol = this.model.getNetworkNameColumnIndex();
        this.clickHandler = new ClickHandler();
        table.addMouseListener(this.clickHandler);
    }

    void createPopup(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu(this.ni.getNetworkName());
        for (MiSpec mis : this.miSpecs) {
            if (!mis.cmd.isNetworkCmd()) continue;
            menu.add(mis.createMenuItem());
        }
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    private class MiSpec {
        PPEManager.Cmd cmd;
        boolean enable;
        ActionCommand ac;
        String txt;

        MiSpec(PPEManager.Cmd cmd) {
            this.cmd = cmd;
            this.ac = new ActionCommand(cmd.toString(), NetworkTablePopup.this.ni.getNetworkID(), null);
            this.txt = cmd.getTitle();
            this.enable = NetworkTablePopup.this.ni.isRunning();
        }

        JMenuItem createMenuItem() {
            JMenuItem mi = new JMenuItem();
            mi.setActionCommand(this.ac.toActionEventString());
            mi.setText(this.txt);
            mi.addActionListener(NetworkTablePopup.this.ppeManager);
            mi.setEnabled(this.enable);
            return mi;
        }
    }

    class CreatePopup
    extends Thread {
        MouseEvent e;
        int idx;
        boolean rebootInstances;
        boolean terminateInstances;
        boolean startRmxServerOnMaster;
        boolean configureOmpi;
        boolean startRserveController;

        CreatePopup(MouseEvent e) {
            this.e = e;
        }

        @Override
        public void run() {
            try {
                int idx = NetworkTablePopup.this.table.rowAtPoint(this.e.getPoint());
                if (idx < 0) {
                    return;
                }
                Object x = NetworkTablePopup.this.model.getValueAt(idx, NetworkTablePopup.this.networkNameCol);
                if (x == null) {
                    return;
                }
                String networkName = (String)x;
                NetworkTablePopup.this.ni = NiM.getForName(networkName);
                if (NetworkTablePopup.this.ni == null) {
                    return;
                }
                NetworkTablePopup.this.miSpecs = new ArrayList<MiSpec>();
                for (PPEManager.Cmd cmd : PPEManager.Cmd.values()) {
                    NetworkTablePopup.this.miSpecs.add(new MiSpec(cmd));
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NetworkTablePopup.this.createPopup(CreatePopup.this.e);
                    }
                });
            }
            catch (Exception xxx) {
                ExceptionHandler.gui(xxx);
            }
        }
    }

    class ClickHandler
    extends MouseAdapter {
        ClickHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            new CreatePopup(e).start();
        }
    }
}

